"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolvedArgsReducer = void 0;
var _reduxActions = require("redux-actions");
var _objectPathImmutable = require("object-path-immutable");
var _lodash = require("lodash");
var _modify_path = require("../../lib/modify_path");
var actions = _interopRequireWildcard(require("../actions/resolved_args"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
  Resolved args are a way to handle async values. They track the status, value, and error
  state thgouh the lifecycle of the request, and are an object that looks like this:

  {
    status: 'pending',
    value: null,
    error: null,
  }

  Here, the request is in flight, and the application is waiting for a value. Valid statuses
  are `initializing`, `pending`, `ready`, and `error`.

  When status is `ready`, the value will be whatever came back in the response.

  When status is `error`, the value will not change, and the error property will be the error.
*/

function _getState(hasError, loading) {
  if (hasError) {
    return 'error';
  }
  if (Boolean(loading)) {
    return 'pending';
  }
  return 'ready';
}
function _getValue(hasError, value, oldVal) {
  if (hasError || value == null) {
    return oldVal && oldVal.value;
  }
  return value;
}
function getContext(value, loading = false, oldVal = null) {
  // TODO: this is no longer correct.
  const hasError = value instanceof Error;
  return {
    state: _getState(hasError, loading),
    value: _getValue(hasError, value, oldVal),
    error: hasError ? value : null
  };
}
function getFullPath(path) {
  const isArray = Array.isArray(path);
  const isString = typeof path === 'string';
  if (!isArray && !isString) {
    throw new Error(`Resolved argument path is invalid: ${path}`);
  }
  return (0, _modify_path.prepend)(path, 'resolvedArgs');
}
const resolvedArgsReducer = exports.resolvedArgsReducer = (0, _reduxActions.handleActions)({
  [actions.setLoading]: (transientState, {
    payload
  }) => {
    const {
      path,
      loading = true
    } = payload;
    const fullPath = getFullPath(path);
    const oldVal = (0, _lodash.get)(transientState, fullPath, null);
    return (0, _objectPathImmutable.set)(transientState, fullPath, getContext((0, _lodash.get)(oldVal, 'value', null), loading));
  },
  [actions.setValue]: (transientState, {
    payload
  }) => {
    const {
      path,
      value
    } = payload;
    const fullPath = getFullPath(path);
    const oldVal = (0, _lodash.get)(transientState, fullPath, null);
    return (0, _objectPathImmutable.set)(transientState, fullPath, getContext(value, false, oldVal));
  },
  [actions.setValues]: (transientState, {
    payload
  }) => {
    return payload.reduce((acc, setValueObj) => {
      const fullPath = getFullPath(setValueObj.path);
      const oldVal = (0, _lodash.get)(acc, fullPath, null);
      return (0, _objectPathImmutable.set)(acc, fullPath, getContext(setValueObj.value, false, oldVal));
    }, transientState);
  },
  [actions.clearValue]: (transientState, {
    payload
  }) => {
    const {
      path
    } = payload;
    return (0, _objectPathImmutable.del)(transientState, getFullPath(path));
  },
  [actions.clearValues]: (transientState, {
    payload
  }) => {
    return payload.reduce((transientState, path) => {
      return (0, _objectPathImmutable.del)(transientState, getFullPath(path));
    }, transientState);
  },
  [actions.inFlightActive]: transientState => {
    return (0, _objectPathImmutable.set)(transientState, 'inFlight', true);
  },
  [actions.inFlightComplete]: transientState => {
    return (0, _objectPathImmutable.set)(transientState, 'inFlight', false);
  },
  /*
   * Flush all cached contexts
   */
  ['flushContext']: (transientState, {
    payload: elementId
  }) => {
    return (0, _objectPathImmutable.del)(transientState, getFullPath([elementId, 'expressionContext']));
  },
  /*
   * Flush cached context indices from the given index to the last
   */
  ['flushContextAfterIndex']: (transientState, {
    payload
  }) => {
    const {
      elementId,
      index
    } = payload;
    const expressionContext = (0, _lodash.get)(transientState, getFullPath([elementId, 'expressionContext']));

    // if there is not existing context, there's nothing to do here
    if (!expressionContext) {
      return transientState;
    }
    return Object.keys(expressionContext).reduce((state, indexKey) => {
      const indexAsNum = parseInt(indexKey, 10);
      if (indexAsNum >= index) {
        return (0, _objectPathImmutable.del)(state, getFullPath([elementId, 'expressionContext', indexKey]));
      }
      return state;
    }, transientState);
  },
  ['setWorkpad']: (transientState, {}) => {
    return (0, _objectPathImmutable.set)(transientState, 'resolvedArgs', {});
  }
}, {});