"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultQuery = createDefaultQuery;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDefaultQuery(queryIn, timeField, timeRange) {
  const query = (0, _lodash.cloneDeep)(queryIn !== null && queryIn !== void 0 ? queryIn : {
    match_all: {}
  });
  if (query.bool === undefined) {
    query.bool = Object.create(null);
  }
  if (query.bool.must === undefined) {
    query.bool.must = [];
    if (query.match_all !== undefined) {
      query.bool.must.push({
        match_all: query.match_all
      });
      delete query.match_all;
    }
    if (query.query_string !== undefined) {
      query.bool.must.push({
        query_string: query.query_string
      });
      delete query.query_string;
    }
  }
  if (query.multi_match !== undefined) {
    query.bool.should = {
      multi_match: query.multi_match
    };
    delete query.multi_match;
  }
  if (timeRange !== undefined) {
    query.bool.must.push({
      range: {
        [timeField]: {
          gte: timeRange.from,
          lte: timeRange.to,
          format: 'epoch_millis'
        }
      }
    });
  }
  return query;
}