"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameAndDescriptionStats = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../shared/constants");
var _indices = require("../../utils/indices");
var _connector_name_and_description_flyout = require("./connector/connector_name_and_description/connector_name_and_description_flyout");
var _connector_name_and_description_logic = require("./connector/connector_name_and_description/connector_name_and_description_logic");
var _overview = require("./overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDescription = ({
  label,
  onClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClick
}, "Edit")));
const NameAndDescriptionStats = () => {
  const {
    indexData,
    isError,
    isLoading
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const hideStats = isLoading || isError;
  const {
    setIsEditing: setIsFlyoutVisible
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  if (!(0, _indices.isConnectorIndex)(indexData)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const stats = [{
    description: /*#__PURE__*/_react.default.createElement(EditDescription, {
      label: _constants.NAME_LABEL,
      onClick: () => setIsFlyoutVisible(true)
    }),
    isLoading: hideStats,
    title: indexData.connector.name,
    descriptionElement: 'div',
    titleElement: 'div'
  }, {
    description: /*#__PURE__*/_react.default.createElement(EditDescription, {
      label: _constants.DESCRIPTION_LABEL,
      onClick: () => setIsFlyoutVisible(true)
    }),
    descriptionElement: 'div',
    isLoading: hideStats,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, indexData.connector.description || ''),
    titleElement: 'div'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, stats.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: 'subdued',
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, (0, _extends2.default)({
    titleSize: "s"
  }, item)))))), /*#__PURE__*/_react.default.createElement(_connector_name_and_description_flyout.ConnectorNameAndDescriptionFlyout, null));
};
exports.NameAndDescriptionStats = NameAndDescriptionStats;