"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pickAvailableMeteringStats = exports.parseMeteringStats = exports.parseIndicesStats = exports.fetchStats = exports.fetchMeteringStats = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchStats = (client, indexPattern) => client.asCurrentUser.indices.stats({
  expand_wildcards: ['open'],
  index: indexPattern
});
exports.fetchStats = fetchStats;
const parseIndicesStats = statsIndices => Object.entries(statsIndices !== null && statsIndices !== void 0 ? statsIndices : {}).reduce((acc, [key, value]) => {
  var _value$primaries$docs, _value$primaries, _value$primaries$docs2, _value$primaries$stor, _value$primaries2, _value$primaries2$sto;
  acc[key] = {
    uuid: value.uuid,
    name: key,
    num_docs: (_value$primaries$docs = value === null || value === void 0 ? void 0 : (_value$primaries = value.primaries) === null || _value$primaries === void 0 ? void 0 : (_value$primaries$docs2 = _value$primaries.docs) === null || _value$primaries$docs2 === void 0 ? void 0 : _value$primaries$docs2.count) !== null && _value$primaries$docs !== void 0 ? _value$primaries$docs : null,
    size_in_bytes: (_value$primaries$stor = value === null || value === void 0 ? void 0 : (_value$primaries2 = value.primaries) === null || _value$primaries2 === void 0 ? void 0 : (_value$primaries2$sto = _value$primaries2.store) === null || _value$primaries2$sto === void 0 ? void 0 : _value$primaries2$sto.size_in_bytes) !== null && _value$primaries$stor !== void 0 ? _value$primaries$stor : null
  };
  return acc;
}, {});
exports.parseIndicesStats = parseIndicesStats;
const fetchMeteringStats = (client, indexPattern, secondaryAuthorization) => client.asInternalUser.transport.request({
  method: 'GET',
  path: `/_metering/stats/${indexPattern}`
}, {
  headers: {
    'es-secondary-authorization': secondaryAuthorization
  }
});
exports.fetchMeteringStats = fetchMeteringStats;
const parseMeteringStats = meteringStatsIndices => meteringStatsIndices.reduce((acc, curr) => {
  acc[curr.name] = curr;
  return acc;
}, {});
exports.parseMeteringStats = parseMeteringStats;
const pickAvailableMeteringStats = (indicesBuckets, meteringStatsIndices) => indicesBuckets.reduce((acc, indexName) => {
  if (meteringStatsIndices !== null && meteringStatsIndices !== void 0 && meteringStatsIndices[indexName]) {
    acc[indexName] = {
      name: meteringStatsIndices === null || meteringStatsIndices === void 0 ? void 0 : meteringStatsIndices[indexName].name,
      num_docs: meteringStatsIndices === null || meteringStatsIndices === void 0 ? void 0 : meteringStatsIndices[indexName].num_docs,
      size_in_bytes: null,
      // We don't have size_in_bytes intentionally when ILM is not available
      data_stream: meteringStatsIndices === null || meteringStatsIndices === void 0 ? void 0 : meteringStatsIndices[indexName].data_stream
    };
  }
  return acc;
}, {});
exports.pickAvailableMeteringStats = pickAvailableMeteringStats;