"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIDEBAR_WIDTH_KEY = exports.DiscoverResizableLayout = void 0;
var _eui = require("@elastic/eui");
var _resizableLayout = require("@kbn/resizable-layout");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _reactReversePortal = require("react-reverse-portal");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SIDEBAR_WIDTH_KEY = exports.SIDEBAR_WIDTH_KEY = 'discover:sidebarWidth';
const DiscoverResizableLayout = ({
  container,
  sidebarToggleState$,
  sidebarPanel,
  mainPanel
}) => {
  var _sidebarToggleState$i;
  const [sidebarPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const minSidebarWidth = euiTheme.base * 13;
  const defaultSidebarWidth = euiTheme.base * 19;
  const minMainPanelWidth = euiTheme.base * 24;
  const [sidebarWidth, setSidebarWidth] = (0, _useLocalStorage.default)(SIDEBAR_WIDTH_KEY, defaultSidebarWidth);
  const sidebarToggleState = (0, _useObservable.default)(sidebarToggleState$);
  const isSidebarCollapsed = (_sidebarToggleState$i = sidebarToggleState === null || sidebarToggleState === void 0 ? void 0 : sidebarToggleState.isCollapsed) !== null && _sidebarToggleState$i !== void 0 ? _sidebarToggleState$i : false;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const layoutMode = isMobile || isSidebarCollapsed ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable;
  const layoutDirection = isMobile ? _resizableLayout.ResizableLayoutDirection.Vertical : _resizableLayout.ResizableLayoutDirection.Horizontal;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: sidebarPanelNode
  }, sidebarPanel), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode
  }, mainPanel), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: "dscPageBody__contents" // class is used in other styles
    ,
    css: dscPageBodyContentsCss,
    mode: layoutMode,
    direction: layoutDirection,
    container: container,
    fixedPanelSize: sidebarWidth !== null && sidebarWidth !== void 0 ? sidebarWidth : defaultSidebarWidth,
    minFixedPanelSize: minSidebarWidth,
    minFlexPanelSize: minMainPanelWidth,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: sidebarPanelNode
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode
    }),
    "data-test-subj": "discoverLayout",
    onFixedPanelSizeChange: setSidebarWidth
  }));
};
exports.DiscoverResizableLayout = DiscoverResizableLayout;
const dscPageBodyContentsCss = (0, _react2.css)`
  overflow: hidden;
  height: 100%;
`;