"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldIntervalInSeconds = void 0;
var _moment = _interopRequireDefault(require("moment/moment"));
var _calculateAuto = require("@kbn/calculate-auto");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldIntervalInSeconds = ({
  start,
  end,
  buckets = 10,
  minIntervalSeconds = 60
}) => {
  var _calculateAuto$near$a, _calculateAuto$near;
  const duration = _moment.default.duration(end - start, 'ms');
  return Math.max((_calculateAuto$near$a = (_calculateAuto$near = _calculateAuto.calculateAuto.near(buckets, duration)) === null || _calculateAuto$near === void 0 ? void 0 : _calculateAuto$near.asSeconds()) !== null && _calculateAuto$near$a !== void 0 ? _calculateAuto$near$a : 0, minIntervalSeconds);
};
exports.getFieldIntervalInSeconds = getFieldIntervalInSeconds;