"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIssuesTable = void 0;
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _use_quality_issues = require("../../../../hooks/use_quality_issues");
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QualityIssuesTable = () => {
  const {
    isDegradedFieldsLoading,
    pagination,
    renderedItems,
    onTableChange,
    sort,
    fieldFormats,
    expandedDegradedField,
    openDegradedFieldFlyout
  } = (0, _use_quality_issues.useQualityIssues)();
  const dateFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const columns = (0, _columns.getQualityIssuesColumns)({
    dateFormatter,
    isLoading: isDegradedFieldsLoading,
    expandedQualityIssue: expandedDegradedField,
    openQualityIssueFlyout: openDegradedFieldFlyout
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "fixed",
    columns: columns,
    items: renderedItems !== null && renderedItems !== void 0 ? renderedItems : [],
    loading: isDegradedFieldsLoading,
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityDetailsDegradedFieldTable",
    rowProps: {
      'data-test-subj': 'datasetQualityDetailsDegradedTableRow'
    },
    noItemsMessage: isDegradedFieldsLoading ? _translations.overviewDegradedFieldsTableLoadingText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityDetailsDegradedTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.qualityIssuesTableNoData),
      hasBorder: false,
      titleSize: "m"
    })
  });
};
exports.QualityIssuesTable = QualityIssuesTable;