"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchSessionSavedObjectType = void 0;
var _configSchema = require("@kbn/config-schema");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../../common");
var _search_session_migration = require("./search_session_migration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchSessionSavedObjectType = exports.searchSessionSavedObjectType = {
  name: _common.SEARCH_SESSION_TYPE,
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  namespaceType: 'single',
  hidden: true,
  mappings: {
    dynamic: false,
    properties: {
      sessionId: {
        type: 'keyword'
      },
      created: {
        type: 'date'
      },
      realmType: {
        type: 'keyword'
      },
      realmName: {
        type: 'keyword'
      },
      username: {
        type: 'keyword'
      }
    }
  },
  schemas: {
    '8.8.0': _configSchema.schema.object({
      sessionId: _configSchema.schema.string(),
      name: _configSchema.schema.maybe(_configSchema.schema.string()),
      created: _configSchema.schema.string(),
      expires: _configSchema.schema.string(),
      appId: _configSchema.schema.maybe(_configSchema.schema.string()),
      locatorId: _configSchema.schema.maybe(_configSchema.schema.string()),
      initialState: _configSchema.schema.maybe(_configSchema.schema.object({}, {
        unknowns: 'allow'
      })),
      restoreState: _configSchema.schema.maybe(_configSchema.schema.object({}, {
        unknowns: 'allow'
      })),
      idMapping: _configSchema.schema.mapOf(_configSchema.schema.string(), _configSchema.schema.object({
        id: _configSchema.schema.string(),
        strategy: _configSchema.schema.string()
      })),
      realmType: _configSchema.schema.maybe(_configSchema.schema.string()),
      realmName: _configSchema.schema.maybe(_configSchema.schema.string()),
      username: _configSchema.schema.maybe(_configSchema.schema.string()),
      version: _configSchema.schema.string(),
      isCanceled: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  migrations: _search_session_migration.searchSessionSavedObjectMigrations,
  excludeOnUpgrade: async () => {
    return {
      bool: {
        must: [{
          term: {
            type: _common.SEARCH_SESSION_TYPE
          }
        }, {
          match: {
            'search-session.persisted': false
          }
        }]
      }
    };
  }
};