"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiSettingsGlobalClient = void 0;
var _ui_settings_client_common = require("./ui_settings_client_common");
var _ui_settings_errors = require("../ui_settings_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Global UiSettingsClient
 */
class UiSettingsGlobalClient extends _ui_settings_client_common.UiSettingsClientCommon {
  constructor(options) {
    super(options);
  }
  async setMany(changes, options = {
    validateKeys: true
  }) {
    const registeredSettings = super.getRegistered();
    if (options.validateKeys) {
      Object.keys(changes).forEach(key => {
        if (!registeredSettings[key]) {
          throw new _ui_settings_errors.SettingNotRegisteredError(key);
        }
      });
    }
    return super.setMany(changes, options);
  }
  async set(key, value) {
    const registeredSettings = super.getRegistered();
    if (!registeredSettings[key]) {
      throw new _ui_settings_errors.SettingNotRegisteredError(key);
    }
    await super.set(key, value);
  }
}
exports.UiSettingsGlobalClient = UiSettingsGlobalClient;