"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializableRuntimeStateToControlGroupSavedObjectState = exports.getDefaultControlGroupState = exports.controlGroupSavedObjectStateToSerializableRuntimeState = void 0;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDefaultControlGroupState = () => ({
  panels: {},
  labelPosition: _common.DEFAULT_CONTROL_LABEL_POSITION,
  chainingSystem: _common.DEFAULT_CONTROL_CHAINING,
  autoApplySelections: _common.DEFAULT_AUTO_APPLY_SELECTIONS,
  ignoreParentSettings: _common.DEFAULT_IGNORE_PARENT_SETTINGS
});
exports.getDefaultControlGroupState = getDefaultControlGroupState;
const safeJSONParse = jsonString => {
  if (!jsonString && typeof jsonString !== 'string') return;
  try {
    return JSON.parse(jsonString);
  } catch {
    return;
  }
};
const controlGroupSavedObjectStateToSerializableRuntimeState = savedObjectState => {
  var _ref, _ref2, _safeJSONParse, _safeJSONParse2;
  const defaultControlGroupInput = getDefaultControlGroupState();
  return {
    chainingSystem: (_ref = savedObjectState === null || savedObjectState === void 0 ? void 0 : savedObjectState.chainingSystem) !== null && _ref !== void 0 ? _ref : defaultControlGroupInput.chainingSystem,
    labelPosition: (_ref2 = savedObjectState === null || savedObjectState === void 0 ? void 0 : savedObjectState.controlStyle) !== null && _ref2 !== void 0 ? _ref2 : defaultControlGroupInput.labelPosition,
    autoApplySelections: !(savedObjectState !== null && savedObjectState !== void 0 && savedObjectState.showApplySelections),
    ignoreParentSettings: (_safeJSONParse = safeJSONParse(savedObjectState === null || savedObjectState === void 0 ? void 0 : savedObjectState.ignoreParentSettingsJSON)) !== null && _safeJSONParse !== void 0 ? _safeJSONParse : {},
    panels: (_safeJSONParse2 = safeJSONParse(savedObjectState === null || savedObjectState === void 0 ? void 0 : savedObjectState.panelsJSON)) !== null && _safeJSONParse2 !== void 0 ? _safeJSONParse2 : {}
  };
};
exports.controlGroupSavedObjectStateToSerializableRuntimeState = controlGroupSavedObjectStateToSerializableRuntimeState;
const serializableRuntimeStateToControlGroupSavedObjectState = serializable => {
  return {
    controlStyle: serializable.labelPosition,
    chainingSystem: serializable.chainingSystem,
    showApplySelections: !Boolean(serializable.autoApplySelections),
    ignoreParentSettingsJSON: JSON.stringify(serializable.ignoreParentSettings),
    panelsJSON: JSON.stringify(serializable.panels)
  };
};
exports.serializableRuntimeStateToControlGroupSavedObjectState = serializableRuntimeStateToControlGroupSavedObjectState;