"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommentRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommentRoute = exports.getCommentRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_COMMENT_DETAILS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string(),
      comment_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'public',
    summary: `Get a case comment or alert`,
    // decription: 'You must have `read` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on the owner of the cases with the comments you're seeking.',
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const res = await client.attachments.get({
        attachmentID: request.params.comment_id,
        caseID: request.params.case_id
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to get comment in route case id: ${request.params.case_id} comment id: ${request.params.comment_id}: ${error}`,
        error
      });
    }
  }
});