"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFieldPasswordStyles = void 0;
var _react = require("@emotion/react");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "u3qgm8-withToggle",
  styles: "&::-ms-reveal{display:none;};label:withToggle;"
} : {
  name: "u3qgm8-withToggle",
  styles: "&::-ms-reveal{display:none;};label:withToggle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFieldPasswordStyles = exports.euiFieldPasswordStyles = function euiFieldPasswordStyles(euiThemeContext) {
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return {
    euiFieldPassword: /*#__PURE__*/(0, _react.css)(formStyles.shared, " &:invalid{", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiFieldPassword;"),
    // Only remove Edge's internal reveal button if we're providing a custom one
    withToggle: _ref,
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, ";label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/(0, _react.css)(formStyles.inGroup, ";label:inGroup;")
  };
};