"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchExperiencesGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _search_experiences = _interopRequireDefault(require("../../../../assets/images/search_experiences.svg"));
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../layout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchExperiencesGuide = () => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchSearchExperiencesPageTemplate, {
    restrictWidth: true,
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.guide.pageTitle', {
        defaultMessage: 'Build a search experience with Search UI'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetSearchExperiencesChrome, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "addContentEmptyPrompt",
    justifyContent: "spaceBetween",
    direction: "row",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, "About Search UI")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.description",
    defaultMessage: "Search UI is a JavaScript library for implementing world-class search experiences without reinventing the wheel. It works out of the box with Elasticsearch, App Search, and Workplace Search, so you can focus on building the best experience for your users, customers, and employees."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: _constants.SEARCH_EXPERIENCES_PLUGIN.DOCUMENTATION_URL,
    target: "_blank",
    color: "primary",
    fill: true,
    iconType: 'popout',
    iconSide: "right"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.documentationLink",
    defaultMessage: "Visit the Search UI documentation"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: _constants.SEARCH_EXPERIENCES_PLUGIN.GITHUB_URL,
    target: "_blank",
    iconType: 'popout',
    iconSide: "right"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.githubLink",
    defaultMessage: "Search UI on Github"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.featuresTitle",
    defaultMessage: "Features"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.features.1",
    defaultMessage: "You know, for search. Elastic builds and maintains Search UI."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.features.2",
    defaultMessage: "Build a complete search experience quickly with a few lines of code."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.features.3",
    defaultMessage: "Search UI is highly customizable, so you can build the perfect search experience for your users."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.features.4",
    defaultMessage: "Searches, paging, filtering, and more, are captured in the URL for direct result linking."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.features.5",
    defaultMessage: "Not just for React. Use with any JavaScript library, even vanilla JavaScript."
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xl",
    float: "right",
    src: _search_experiences.default,
    alt: "Search experiences illustration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchExperiences.guide.tutorialsTitle",
    defaultMessage: "Get started quickly with a tutorial"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "logoElasticsearch"
    }),
    title: "Elasticsearch",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.guide.tutorials.elasticsearch.description', {
      defaultMessage: 'Build a search experience with Elasticsearch and Search UI.'
    }),
    href: _constants.SEARCH_EXPERIENCES_PLUGIN.ELASTICSEARCH_TUTORIAL_URL,
    target: "_blank"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "logoAppSearch"
    }),
    title: "App Search",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.guide.tutorials.appSearch.description', {
      defaultMessage: 'Build a search experience with App Search and Search UI.'
    }),
    href: _constants.SEARCH_EXPERIENCES_PLUGIN.APP_SEARCH_TUTORIAL_URL,
    target: "_blank"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "logoWorkplaceSearch"
    }),
    title: "Workplace Search",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.searchExperiences.guide.tutorials.workplaceSearch.description', {
      defaultMessage: 'Build a search experience with Workplace Search and Search UI.'
    }),
    href: _constants.SEARCH_EXPERIENCES_PLUGIN.WORKPLACE_SEARCH_TUTORIAL_URL,
    target: "_blank"
  })))));
};
exports.SearchExperiencesGuide = SearchExperiencesGuide;