"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConnectorConfig = exports.GenerateConfigApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConnectorConfig = async ({
  connectorId
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/generate_config`;
  return await _http.HttpLogic.values.http.post(route);
};
exports.generateConnectorConfig = generateConnectorConfig;
const GenerateConfigApiLogic = exports.GenerateConfigApiLogic = (0, _create_api_logic.createApiLogic)(['generate_config_api_logic'], generateConnectorConfig);