"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTabItem = exports.createTabActionInjector = exports.createInternalStateAsyncThunk = void 0;
var _uuid = require("uuid");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// For some reason if this is not explicitly typed, TypeScript fails with the following error:
// TS7056: The inferred type of this node exceeds the maximum length the compiler will serialize. An explicit type annotation is needed.

const createInternalStateAsyncThunk = exports.createInternalStateAsyncThunk = _toolkit.createAsyncThunk.withTypes();
const createTabActionInjector = tabId => actionCreator => payload => {
  return actionCreator({
    ...(payload !== null && payload !== void 0 ? payload : {}),
    tabId
  });
};
exports.createTabActionInjector = createTabActionInjector;
const DEFAULT_TAB_LABEL = _i18n.i18n.translate('discover.defaultTabLabel', {
  defaultMessage: 'Untitled'
});
const ESCAPED_DEFAULT_TAB_LABEL = (0, _lodash.escapeRegExp)(DEFAULT_TAB_LABEL);
const DEFAULT_TAB_REGEX = new RegExp(`^${ESCAPED_DEFAULT_TAB_LABEL}( \\d+)?$`); // any default tab
const DEFAULT_TAB_NUMBER_REGEX = new RegExp(`^${ESCAPED_DEFAULT_TAB_LABEL} (?<tabNumber>\\d+)$`); // tab with a number

const createTabItem = allTabs => {
  const id = (0, _uuid.v4)();
  const existingNumbers = allTabs.filter(tab => DEFAULT_TAB_REGEX.test(tab.label.trim())).map(tab => {
    var _match$groups;
    const match = tab.label.trim().match(DEFAULT_TAB_NUMBER_REGEX);
    const tabNumber = match === null || match === void 0 ? void 0 : (_match$groups = match.groups) === null || _match$groups === void 0 ? void 0 : _match$groups.tabNumber;
    return tabNumber ? Number(tabNumber) : 1;
  });
  const nextNumber = existingNumbers.length > 0 ? Math.max(...existingNumbers) + 1 : null;
  const label = nextNumber ? `${DEFAULT_TAB_LABEL} ${nextNumber}` : DEFAULT_TAB_LABEL;
  return {
    id,
    label
  };
};
exports.createTabItem = createTabItem;