"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerHomeAddData = registerHomeAddData;
exports.registerHomeFeatureCatalogue = registerHomeFeatureCatalogue;
var _i18n = require("@kbn/i18n");
var _component_wrapper = require("./lazy_load_bundle/component_wrapper");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerHomeAddData(home, resultsLinks) {
  home.addData.registerAddDataTab({
    id: _constants.FILE_DATA_VIS_TAB_ID,
    name: _i18n.i18n.translate('xpack.dataVisualizer.file.embeddedTabTitle', {
      defaultMessage: 'Upload file'
    }),
    getComponent: () => (0, _component_wrapper.getFileDataVisualizerWrapper)(resultsLinks)
  });
}
function registerHomeFeatureCatalogue(home) {
  home.featureCatalogue.register({
    id: _constants.featureId,
    title: _constants.featureTitle,
    description: _i18n.i18n.translate('xpack.dataVisualizer.description', {
      defaultMessage: 'Import your own CSV, NDJSON, or log file.'
    }),
    icon: 'document',
    path: _constants.applicationPath,
    showOnHomePage: true,
    category: 'data',
    order: 520
  });
}