"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleBuildProgram = handleBuildProgram;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("./constants");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleBuildProgram({
  state,
  model
}) {
  const outputParser = new _output_parsers.StringOutputParser();
  const celProgramGraph = _prompts.CEL_BASE_PROGRAM_PROMPT.pipe(model).pipe(outputParser);
  const program = await celProgramGraph.invoke({
    data_stream_name: state.dataStreamName,
    example_cel_programs: _constants.SAMPLE_CEL_PROGRAMS,
    open_api_path_details: state.openApiPathDetails,
    open_api_schemas: state.openApiSchemas,
    api_query_summary: state.apiQuerySummary,
    ex_answer: _constants.EX_ANSWER_PROGRAM
  });
  return {
    currentProgram: program.trim(),
    lastExecutedChain: 'buildCelProgram'
  };
}