"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnvironmentSelect = useEnvironmentSelect;
var _apmTypes = require("@kbn/apm-types");
var _use_debounce = require("../../../hooks/use_debounce");
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useEnvironmentSelect({
  serviceName,
  start,
  end
}) {
  const [debouncedSearchValue, setDebouncedSearchValue] = (0, _use_debounce.useStateDebounced)('');
  const {
    data,
    status: searchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return debouncedSearchValue.trim() === '' ? Promise.resolve({
      terms: []
    }) : callApmApi('GET /internal/apm/suggestions', {
      params: {
        query: {
          fieldName: _apmTypes.SERVICE_ENVIRONMENT,
          fieldValue: debouncedSearchValue,
          serviceName,
          start,
          end
        }
      }
    });
  }, [debouncedSearchValue, start, end, serviceName]);
  const onSearchChange = value => {
    setDebouncedSearchValue(value);
  };
  return {
    data,
    searchStatus,
    onSearchChange
  };
}