"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialAlertValues = getInitialAlertValues;
var _apm_rule_types = require("../../../../common/rules/apm_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInitialAlertValues(ruleType, serviceName) {
  const ruleTypeName = ruleType ? _apm_rule_types.RULE_TYPES_CONFIG[ruleType].name : undefined;
  const alertName = ruleTypeName ? serviceName ? `${ruleTypeName} | ${serviceName}` : ruleTypeName : undefined;
  const tags = ['apm'];
  if (serviceName) {
    tags.push(`service.name:${serviceName}`.toLowerCase());
  }
  return {
    tags,
    ...(alertName ? {
      name: alertName
    } : {})
  };
}