/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.SharedAccessAccountPolicy;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.analytics.CloudAnalyticsClient;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import com.microsoft.azure.storage.table.CloudTableClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CloudStorageAccount {
    protected static final String ACCOUNT_KEY_NAME = "AccountKey";
    protected static final String ACCOUNT_TOKEN_NAME = "AccountToken";
    protected static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String DNS_NAME_FORMAT = "%s.%s";
    private static final String DEFAULT_DNS = "core.windows.net";
    private static final String SECONDARY_LOCATION_ACCOUNT_SUFFIX = "-secondary";
    private static final String ENDPOINT_SUFFIX_NAME = "EndpointSuffix";
    protected static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    protected static final String BLOB_SECONDARY_ENDPOINT_NAME = "BlobSecondaryEndpoint";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
    private static final String DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT = "%s://%s:%s/%s";
    private static final String DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT = "%s://%s:%s/%s-secondary";
    private static final String DEVELOPMENT_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
    private static final String DEVSTORE_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String DEVSTORE_ACCOUNT_NAME = "devstoreaccount1";
    private static final String FILE_ENDPOINT_NAME = "FileEndpoint";
    private static final String FILE_SECONDARY_ENDPOINT_NAME = "FileSecondaryEndpoint";
    private static final String PRIMARY_ENDPOINT_FORMAT = "%s://%s.%s";
    private static final String SECONDARY_ENDPOINT_FORMAT = "%s://%s%s.%s";
    protected static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
    protected static final String QUEUE_SECONDARY_ENDPOINT_NAME = "QueueSecondaryEndpoint";
    protected static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
    protected static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
    protected static final String TABLE_SECONDARY_ENDPOINT_NAME = "TableSecondaryEndpoint";
    private static final String USE_DEVELOPMENT_STORAGE_NAME = "UseDevelopmentStorage";
    private static ConnectionStringFilter validCredentials = CloudStorageAccount.matchesOne(CloudStorageAccount.matchesAll(CloudStorageAccount.allRequired("AccountName", "AccountKey"), CloudStorageAccount.none("SharedAccessSignature")), CloudStorageAccount.matchesAll(CloudStorageAccount.allRequired("SharedAccessSignature"), CloudStorageAccount.optional("AccountName"), CloudStorageAccount.none("AccountKey")), CloudStorageAccount.none("AccountName", "AccountKey", "SharedAccessSignature"));
    private String endpointSuffix;
    private final StorageUri blobStorageUri;
    private final StorageUri fileStorageUri;
    private final StorageUri queueStorageUri;
    private final StorageUri tableStorageUri;
    private StorageCredentials credentials;
    private String accountName;
    private boolean isBlobEndpointDefault = false;
    private boolean isFileEndpointDefault = false;
    private boolean isQueueEndpointDefault = false;
    private boolean isTableEndpointDefault = false;
    private boolean isDevStoreAccount = false;

    public static CloudStorageAccount getDevelopmentStorageAccount() {
        try {
            return CloudStorageAccount.getDevelopmentStorageAccount(null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static CloudStorageAccount getDevelopmentStorageAccount(URI proxyUri) throws URISyntaxException {
        String host;
        String scheme;
        if (proxyUri == null) {
            scheme = "http";
            host = "127.0.0.1";
        } else {
            scheme = proxyUri.getScheme();
            host = proxyUri.getHost();
        }
        StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(DEVSTORE_ACCOUNT_NAME, DEVSTORE_ACCOUNT_KEY);
        URI blobPrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queuePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tablePrimaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_PRIMARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        URI blobSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10000", DEVSTORE_ACCOUNT_NAME));
        URI queueSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10001", DEVSTORE_ACCOUNT_NAME));
        URI tableSecondaryEndpoint = new URI(String.format(DEVELOPMENT_STORAGE_SECONDARY_ENDPOINT_FORMAT, scheme, host, "10002", DEVSTORE_ACCOUNT_NAME));
        CloudStorageAccount account = new CloudStorageAccount((StorageCredentials)credentials, new StorageUri(blobPrimaryEndpoint, blobSecondaryEndpoint), new StorageUri(queuePrimaryEndpoint, queueSecondaryEndpoint), new StorageUri(tablePrimaryEndpoint, tableSecondaryEndpoint), null);
        account.isDevStoreAccount = true;
        return account;
    }

    public static CloudStorageAccount parse(String connectionString) throws URISyntaxException, InvalidKeyException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Invalid connection string.");
        }
        HashMap<String, String> settings = Utility.parseAccountString(connectionString);
        for (Map.Entry entry : settings.entrySet()) {
            if (entry.getValue() != null && !((String)entry.getValue()).equals("")) continue;
            throw new IllegalArgumentException("Invalid connection string.");
        }
        CloudStorageAccount account = CloudStorageAccount.tryConfigureDevStore(settings);
        if (account != null) {
            return account;
        }
        account = CloudStorageAccount.tryConfigureServiceAccount(settings);
        if (account != null) {
            return account;
        }
        throw new IllegalArgumentException("Invalid connection string.");
    }

    private static StorageUri getStorageUri(Map<String, String> settings, String service, String serviceEndpointName, String serviceSecondaryEndpointName, Boolean matchesAutomaticEndpointsSpec) throws URISyntaxException {
        String serviceEndpoint = CloudStorageAccount.settingOrDefault(settings, serviceEndpointName);
        String serviceSecondaryEndpoint = CloudStorageAccount.settingOrDefault(settings, serviceSecondaryEndpointName);
        if (serviceSecondaryEndpoint != null && serviceEndpoint != null) {
            return new StorageUri(new URI(serviceEndpoint), new URI(serviceSecondaryEndpoint));
        }
        if (serviceEndpoint != null) {
            return new StorageUri(new URI(serviceEndpoint));
        }
        if (matchesAutomaticEndpointsSpec.booleanValue()) {
            String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME);
            String accountName = settings.get(ACCOUNT_NAME_NAME);
            String endpointSuffix = settings.get(ENDPOINT_SUFFIX_NAME);
            return CloudStorageAccount.getDefaultStorageUri(scheme, accountName, CloudStorageAccount.getDNS(service, endpointSuffix));
        }
        return null;
    }

    private static StorageUri getDefaultStorageUri(String scheme, String accountName, String service) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        URI primaryUri = new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, service));
        URI secondaryUri = new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, service));
        return new StorageUri(primaryUri, secondaryUri);
    }

    private static String getDNS(String service, String base) {
        if (base == null) {
            base = DEFAULT_DNS;
        }
        return String.format(DNS_NAME_FORMAT, service, base);
    }

    private static CloudStorageAccount tryConfigureDevStore(Map<String, String> settings) throws URISyntaxException {
        if (CloudStorageAccount.matchesSpecification(settings, CloudStorageAccount.allRequired(USE_DEVELOPMENT_STORAGE_NAME), CloudStorageAccount.optional(DEVELOPMENT_STORAGE_PROXY_URI_NAME)).booleanValue()) {
            if (!Boolean.parseBoolean(settings.get(USE_DEVELOPMENT_STORAGE_NAME))) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            URI devStoreProxyUri = null;
            if (settings.containsKey(DEVELOPMENT_STORAGE_PROXY_URI_NAME)) {
                devStoreProxyUri = new URI(settings.get(DEVELOPMENT_STORAGE_PROXY_URI_NAME));
            }
            return CloudStorageAccount.getDevelopmentStorageAccount(devStoreProxyUri);
        }
        return null;
    }

    private static ConnectionStringFilter allRequired(final String ... settingNames) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                HashMap<String, String> result = new HashMap<String, String>(settings);
                for (String settingName : settingNames) {
                    if (!result.containsKey(settingName)) {
                        return null;
                    }
                    result.remove(settingName);
                }
                return result;
            }
        };
    }

    private static ConnectionStringFilter optional(final String ... settingNames) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                HashMap<String, String> result = new HashMap<String, String>(settings);
                for (String settingName : settingNames) {
                    if (!result.containsKey(settingName)) continue;
                    result.remove(settingName);
                }
                return result;
            }
        };
    }

    private static ConnectionStringFilter atLeastOne(final String ... settingNames) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                HashMap<String, String> result = new HashMap<String, String>(settings);
                Boolean foundOne = false;
                for (String settingName : settingNames) {
                    if (!result.containsKey(settingName)) continue;
                    result.remove(settingName);
                    foundOne = true;
                }
                return foundOne != false ? result : null;
            }
        };
    }

    private static ConnectionStringFilter none(final String ... settingNames) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                HashMap<String, String> result = new HashMap<String, String>(settings);
                Boolean foundOne = false;
                for (String settingName : settingNames) {
                    if (!result.containsKey(settingName)) continue;
                    result.remove(settingName);
                    foundOne = true;
                }
                return foundOne != false ? null : result;
            }
        };
    }

    private static ConnectionStringFilter matchesAll(final ConnectionStringFilter ... filters) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                Map<String, String> result = new HashMap<String, String>(settings);
                for (ConnectionStringFilter filter : filters) {
                    if (result == null) break;
                    result = filter.apply(result);
                }
                return result;
            }
        };
    }

    private static ConnectionStringFilter matchesOne(final ConnectionStringFilter ... filters) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                Map<String, String> matchResult = null;
                for (ConnectionStringFilter filter : filters) {
                    Map<String, String> result = filter.apply(new HashMap<String, String>(settings));
                    if (result == null) continue;
                    if (matchResult == null) {
                        matchResult = result;
                        continue;
                    }
                    return null;
                }
                return matchResult;
            }
        };
    }

    private static ConnectionStringFilter matchesExactly(final ConnectionStringFilter filter) {
        return new ConnectionStringFilter(){

            @Override
            public Map<String, String> apply(Map<String, String> settings) {
                Map<String, String> result = new HashMap<String, String>(settings);
                if ((result = filter.apply(result)) == null || !result.isEmpty()) {
                    return null;
                }
                return result;
            }
        };
    }

    private static Boolean matchesSpecification(Map<String, String> settings, ConnectionStringFilter ... constraints) {
        for (ConnectionStringFilter constraint : constraints) {
            Map<String, String> remainingSettings = constraint.apply(settings);
            if (remainingSettings == null) {
                return false;
            }
            settings = remainingSettings;
        }
        if (settings.isEmpty()) {
            return true;
        }
        return false;
    }

    private static Boolean isValidEndpointPair(String primary, String secondary) {
        return primary != null || secondary == null;
    }

    private static String settingOrDefault(Map<String, String> settings, String key) {
        return settings.containsKey(key) ? settings.get(key) : null;
    }

    private static CloudStorageAccount tryConfigureServiceAccount(Map<String, String> settings) throws URISyntaxException, InvalidKeyException {
        ConnectionStringFilter endpointsOptional = CloudStorageAccount.optional(BLOB_ENDPOINT_NAME, BLOB_SECONDARY_ENDPOINT_NAME, QUEUE_ENDPOINT_NAME, QUEUE_SECONDARY_ENDPOINT_NAME, TABLE_ENDPOINT_NAME, TABLE_SECONDARY_ENDPOINT_NAME, FILE_ENDPOINT_NAME, FILE_SECONDARY_ENDPOINT_NAME);
        ConnectionStringFilter primaryEndpointRequired = CloudStorageAccount.atLeastOne(BLOB_ENDPOINT_NAME, QUEUE_ENDPOINT_NAME, TABLE_ENDPOINT_NAME, FILE_ENDPOINT_NAME);
        ConnectionStringFilter secondaryEndpointsOptional = CloudStorageAccount.optional(BLOB_SECONDARY_ENDPOINT_NAME, QUEUE_SECONDARY_ENDPOINT_NAME, TABLE_SECONDARY_ENDPOINT_NAME, FILE_SECONDARY_ENDPOINT_NAME);
        ConnectionStringFilter automaticEndpointsMatchSpec = CloudStorageAccount.matchesExactly(CloudStorageAccount.matchesAll(CloudStorageAccount.matchesOne(CloudStorageAccount.matchesAll(CloudStorageAccount.allRequired(ACCOUNT_KEY_NAME)), CloudStorageAccount.allRequired(SHARED_ACCESS_SIGNATURE_NAME)), CloudStorageAccount.allRequired(ACCOUNT_NAME_NAME), endpointsOptional, CloudStorageAccount.optional(DEFAULT_ENDPOINTS_PROTOCOL_NAME, ENDPOINT_SUFFIX_NAME)));
        ConnectionStringFilter explicitEndpointsMatchSpec = CloudStorageAccount.matchesExactly(CloudStorageAccount.matchesAll(validCredentials, primaryEndpointRequired, secondaryEndpointsOptional));
        Boolean matchesAutomaticEndpointsSpec = CloudStorageAccount.matchesSpecification(settings, automaticEndpointsMatchSpec);
        Boolean matchesExplicitEndpointsSpec = CloudStorageAccount.matchesSpecification(settings, explicitEndpointsMatchSpec);
        if (matchesAutomaticEndpointsSpec.booleanValue() || matchesExplicitEndpointsSpec.booleanValue()) {
            if (matchesAutomaticEndpointsSpec.booleanValue() && !settings.containsKey(DEFAULT_ENDPOINTS_PROTOCOL_NAME)) {
                settings.put(DEFAULT_ENDPOINTS_PROTOCOL_NAME, "https");
            }
            String blobEndpoint = CloudStorageAccount.settingOrDefault(settings, BLOB_ENDPOINT_NAME);
            String queueEndpoint = CloudStorageAccount.settingOrDefault(settings, QUEUE_ENDPOINT_NAME);
            String tableEndpoint = CloudStorageAccount.settingOrDefault(settings, TABLE_ENDPOINT_NAME);
            String fileEndpoint = CloudStorageAccount.settingOrDefault(settings, FILE_ENDPOINT_NAME);
            String blobSecondaryEndpoint = CloudStorageAccount.settingOrDefault(settings, BLOB_SECONDARY_ENDPOINT_NAME);
            String queueSecondaryEndpoint = CloudStorageAccount.settingOrDefault(settings, QUEUE_SECONDARY_ENDPOINT_NAME);
            String tableSecondaryEndpoint = CloudStorageAccount.settingOrDefault(settings, TABLE_SECONDARY_ENDPOINT_NAME);
            String fileSecondaryEndpoint = CloudStorageAccount.settingOrDefault(settings, FILE_SECONDARY_ENDPOINT_NAME);
            if (CloudStorageAccount.isValidEndpointPair(blobEndpoint, blobSecondaryEndpoint).booleanValue() && CloudStorageAccount.isValidEndpointPair(queueEndpoint, queueSecondaryEndpoint).booleanValue() && CloudStorageAccount.isValidEndpointPair(tableEndpoint, tableSecondaryEndpoint).booleanValue() && CloudStorageAccount.isValidEndpointPair(fileEndpoint, fileSecondaryEndpoint).booleanValue()) {
                CloudStorageAccount accountInformation = new CloudStorageAccount(StorageCredentials.tryParseCredentials(settings), CloudStorageAccount.getStorageUri(settings, "blob", BLOB_ENDPOINT_NAME, BLOB_SECONDARY_ENDPOINT_NAME, matchesAutomaticEndpointsSpec), CloudStorageAccount.getStorageUri(settings, "queue", QUEUE_ENDPOINT_NAME, QUEUE_SECONDARY_ENDPOINT_NAME, matchesAutomaticEndpointsSpec), CloudStorageAccount.getStorageUri(settings, "table", TABLE_ENDPOINT_NAME, TABLE_SECONDARY_ENDPOINT_NAME, matchesAutomaticEndpointsSpec), CloudStorageAccount.getStorageUri(settings, "file", FILE_ENDPOINT_NAME, FILE_SECONDARY_ENDPOINT_NAME, matchesAutomaticEndpointsSpec));
                accountInformation.isBlobEndpointDefault = blobEndpoint == null;
                accountInformation.isFileEndpointDefault = fileEndpoint == null;
                accountInformation.isQueueEndpointDefault = queueEndpoint == null;
                accountInformation.isTableEndpointDefault = tableEndpoint == null;
                accountInformation.endpointSuffix = CloudStorageAccount.settingOrDefault(settings, ENDPOINT_SUFFIX_NAME);
                accountInformation.accountName = CloudStorageAccount.settingOrDefault(settings, ACCOUNT_NAME_NAME);
                return accountInformation;
            }
        }
        return null;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials) throws URISyntaxException {
        this(storageCredentials, false, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, boolean useHttps) throws URISyntaxException {
        this(storageCredentials, useHttps, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, boolean useHttps, String endpointSuffix) throws URISyntaxException {
        this(storageCredentials, useHttps, endpointSuffix, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, boolean useHttps, String endpointSuffix, String accountName) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        if (Utility.isNullOrEmpty(accountName)) {
            accountName = storageCredentials.getAccountName();
        } else if (!Utility.isNullOrEmpty(storageCredentials.getAccountName()) && !accountName.equals(storageCredentials.getAccountName())) {
            throw new IllegalArgumentException("The account name does not match the existing account name on the credentials.");
        }
        String protocol = useHttps ? "https" : "http";
        this.credentials = storageCredentials;
        this.blobStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, accountName, CloudStorageAccount.getDNS("blob", endpointSuffix));
        this.fileStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, accountName, CloudStorageAccount.getDNS("file", endpointSuffix));
        this.queueStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, accountName, CloudStorageAccount.getDNS("queue", endpointSuffix));
        this.tableStorageUri = CloudStorageAccount.getDefaultStorageUri(protocol, accountName, CloudStorageAccount.getDNS("table", endpointSuffix));
        this.endpointSuffix = endpointSuffix;
        this.isBlobEndpointDefault = true;
        this.isFileEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint, URI fileEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint), new StorageUri(fileEndpoint));
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri) {
        this(storageCredentials, blobStorageUri, queueStorageUri, tableStorageUri, null);
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri, StorageUri fileStorageUri) {
        this.credentials = storageCredentials;
        this.blobStorageUri = blobStorageUri;
        this.fileStorageUri = fileStorageUri;
        this.queueStorageUri = queueStorageUri;
        this.tableStorageUri = tableStorageUri;
        this.endpointSuffix = null;
    }

    public CloudAnalyticsClient createCloudAnalyticsClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        return new CloudAnalyticsClient(this.getBlobStorageUri(), this.getTableStorageUri(), this.getCredentials());
    }

    public CloudBlobClient createCloudBlobClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        return new CloudBlobClient(this.getBlobStorageUri(), this.getCredentials());
    }

    public CloudFileClient createCloudFileClient() {
        if (this.getFileStorageUri() == null) {
            throw new IllegalArgumentException("No file endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsGenerateClient(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudFileClient(this.getFileStorageUri(), this.getCredentials());
    }

    public CloudQueueClient createCloudQueueClient() {
        if (this.getQueueStorageUri() == null) {
            throw new IllegalArgumentException("No queue endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsGenerateClient(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudQueueClient(this.getQueueStorageUri(), this.getCredentials());
    }

    public CloudTableClient createCloudTableClient() {
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!StorageCredentialsHelper.canCredentialsGenerateClient(this.credentials)) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudTableClient(this.getTableStorageUri(), this.getCredentials());
    }

    public URI getBlobEndpoint() {
        if (this.blobStorageUri == null) {
            return null;
        }
        return this.blobStorageUri.getPrimaryUri();
    }

    public StorageUri getBlobStorageUri() {
        return this.blobStorageUri;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public URI getFileEndpoint() {
        if (this.fileStorageUri == null) {
            return null;
        }
        return this.fileStorageUri.getPrimaryUri();
    }

    public StorageUri getFileStorageUri() {
        return this.fileStorageUri;
    }

    public URI getQueueEndpoint() {
        if (this.queueStorageUri == null) {
            return null;
        }
        return this.queueStorageUri.getPrimaryUri();
    }

    public StorageUri getQueueStorageUri() {
        return this.queueStorageUri;
    }

    public URI getTableEndpoint() {
        if (this.tableStorageUri == null) {
            return null;
        }
        return this.tableStorageUri.getPrimaryUri();
    }

    public StorageUri getTableStorageUri() {
        return this.tableStorageUri;
    }

    public String generateSharedAccessSignature(SharedAccessAccountPolicy policy) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.getCredentials())) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String sig = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForAccount(this.credentials.getAccountName(), policy, this.getCredentials());
        UriQueryBuilder sasBuilder = SharedAccessSignatureHelper.generateSharedAccessSignatureForAccount(policy, sig);
        return sasBuilder.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean exportSecrets) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.isDevStoreAccount) {
            values.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
            if (!this.getBlobEndpoint().toString().equals("http://127.0.0.1:10000/devstoreaccount1")) {
                values.add(String.format("%s=%s://%s/", DEVELOPMENT_STORAGE_PROXY_URI_NAME, this.getBlobEndpoint().getScheme(), this.getBlobEndpoint().getHost()));
            }
        } else {
            String attributeFormat = "%s=%s";
            boolean addDefault = false;
            if (this.endpointSuffix != null) {
                values.add(String.format("%s=%s", ENDPOINT_SUFFIX_NAME, this.endpointSuffix));
            }
            if (this.getBlobStorageUri() != null) {
                if (this.isBlobEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", BLOB_ENDPOINT_NAME, this.getBlobEndpoint()));
                }
            }
            if (this.getQueueStorageUri() != null) {
                if (this.isQueueEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", QUEUE_ENDPOINT_NAME, this.getQueueEndpoint()));
                }
            }
            if (this.getTableStorageUri() != null) {
                if (this.isTableEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", TABLE_ENDPOINT_NAME, this.getTableEndpoint()));
                }
            }
            if (this.getFileStorageUri() != null) {
                if (this.isFileEndpointDefault) {
                    addDefault = true;
                } else {
                    values.add(String.format("%s=%s", FILE_ENDPOINT_NAME, this.getFileEndpoint()));
                }
            }
            if (addDefault) {
                values.add(String.format("%s=%s", DEFAULT_ENDPOINTS_PROTOCOL_NAME, this.getBlobEndpoint().getScheme()));
            }
            if (this.getCredentials() != null) {
                values.add(this.getCredentials().toString(exportSecrets));
            }
            if (this.accountName != null && (this.getCredentials() == null || this.getCredentials().getAccountName() == null)) {
                values.add(String.format("%s=%s", ACCOUNT_NAME_NAME, this.accountName));
            }
        }
        StringBuilder returnString = new StringBuilder();
        for (String val : values) {
            returnString.append(val);
            returnString.append(';');
        }
        if (values.size() > 0) {
            returnString.deleteCharAt(returnString.length() - 1);
        }
        return returnString.toString();
    }

    protected void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    private static interface ConnectionStringFilter {
        public Map<String, String> apply(Map<String, String> var1);
    }
}

