/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DatabaseConfigurationMetadata(DatabaseConfiguration database, long version, long modifiedDate) implements SimpleDiffable<DatabaseConfigurationMetadata>,
ToXContentObject
{
    public static final ParseField DATABASE = new ParseField("database", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField MODIFIED_DATE_MILLIS = new ParseField("modified_date_millis", new String[0]);
    public static final ParseField MODIFIED_DATE = new ParseField("modified_date", new String[0]);
    public static final ConstructingObjectParser<DatabaseConfigurationMetadata, String> PARSER = new ConstructingObjectParser("database_metadata", true, a -> {
        DatabaseConfiguration database = (DatabaseConfiguration)a[0];
        return new DatabaseConfigurationMetadata(database, (Long)a[1], (Long)a[2]);
    });

    public DatabaseConfigurationMetadata(StreamInput in) throws IOException {
        this(new DatabaseConfiguration(in), in.readVLong(), in.readVLong());
    }

    public static DatabaseConfigurationMetadata parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VERSION.getPreferredName(), this.version);
        builder.timestampFieldsFromUnixEpochMillis(MODIFIED_DATE_MILLIS.getPreferredName(), MODIFIED_DATE.getPreferredName(), this.modifiedDate);
        builder.field(DATABASE.getPreferredName(), this.database);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.database.writeTo(out);
        out.writeVLong(this.version);
        out.writeVLong(this.modifiedDate);
    }

    public static Diff<DatabaseConfigurationMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DatabaseConfigurationMetadata::new, in);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), DatabaseConfiguration::parse, DATABASE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_MILLIS);
    }
}

