/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.search.lookup.Source;

public abstract class SearchBasedChangesSnapshot
implements Translog.Snapshot,
Closeable {
    public static final int DEFAULT_BATCH_SIZE = 1024;
    private final IndexSettings indexSettings;
    private final IndexSearcher indexSearcher;
    private final ValueFetcher sourceMetadataFetcher;
    private final Closeable onClose;
    protected final long fromSeqNo;
    protected final long toSeqNo;
    protected final boolean requiredFullRange;
    protected final int searchBatchSize;
    private final boolean accessStats;
    private final int totalHits;
    private FieldDoc afterDoc;
    private long lastSeenSeqNo;

    protected SearchBasedChangesSnapshot(MapperService mapperService, Engine.Searcher engineSearcher, int searchBatchSize, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accessStats, IndexVersion indexVersionCreated) throws IOException {
        if (fromSeqNo < 0L || toSeqNo < 0L || fromSeqNo > toSeqNo) {
            throw new IllegalArgumentException("Invalid range; from_seqno [" + fromSeqNo + "], to_seqno [" + toSeqNo + "]");
        }
        if (searchBatchSize <= 0) {
            throw new IllegalArgumentException("Search_batch_size must be positive [" + searchBatchSize + "]");
        }
        AtomicBoolean closed = new AtomicBoolean();
        this.onClose = () -> {
            if (closed.compareAndSet(false, true)) {
                IOUtils.close((Closeable)engineSearcher);
            }
        };
        this.indexSettings = mapperService.getIndexSettings();
        this.fromSeqNo = fromSeqNo;
        this.toSeqNo = toSeqNo;
        this.lastSeenSeqNo = fromSeqNo - 1L;
        this.requiredFullRange = requiredFullRange;
        this.indexSearcher = SearchBasedChangesSnapshot.newIndexSearcher(engineSearcher);
        this.indexSearcher.setQueryCache(null);
        long requestingSize = toSeqNo - fromSeqNo == Long.MAX_VALUE ? Long.MAX_VALUE : toSeqNo - fromSeqNo + 1L;
        this.searchBatchSize = (int)Math.min(requestingSize, (long)searchBatchSize);
        this.accessStats = accessStats;
        this.totalHits = accessStats ? this.indexSearcher.count(SearchBasedChangesSnapshot.rangeQuery(this.indexSettings, fromSeqNo, toSeqNo)) : -1;
        this.sourceMetadataFetcher = this.createSourceMetadataValueFetcher(mapperService, this.indexSearcher);
    }

    private ValueFetcher createSourceMetadataValueFetcher(MapperService mapperService, IndexSearcher searcher) {
        if (mapperService.mappingLookup().inferenceFields().isEmpty()) {
            return null;
        }
        InferenceMetadataFieldsMapper mapper = (InferenceMetadataFieldsMapper)mapperService.mappingLookup().getMapping().getMetadataMapperByName("_inference_fields");
        return mapper != null ? mapper.fieldType().valueFetcher(mapperService.mappingLookup(), mapperService.getBitSetProducer(), searcher) : null;
    }

    protected abstract Translog.Operation nextOperation() throws IOException;

    public List<LeafReaderContext> leaves() {
        return this.indexSearcher.getIndexReader().leaves();
    }

    @Override
    public int totalOperations() {
        if (!this.accessStats) {
            throw new IllegalStateException("Access stats of a snapshot created with [access_stats] is false");
        }
        return this.totalHits;
    }

    @Override
    public final Translog.Operation next() throws IOException {
        Translog.Operation op = this.nextOperation();
        if (this.requiredFullRange) {
            this.verifyRange(op);
        }
        if (op != null) {
            assert (this.fromSeqNo <= op.seqNo() && op.seqNo() <= this.toSeqNo && this.lastSeenSeqNo < op.seqNo()) : "Unexpected operation; last_seen_seqno [" + this.lastSeenSeqNo + "], from_seqno [" + this.fromSeqNo + "], to_seqno [" + this.toSeqNo + "], op [" + String.valueOf(op) + "]";
            this.lastSeenSeqNo = op.seqNo();
        }
        return op;
    }

    @Override
    public void close() throws IOException {
        this.onClose.close();
    }

    protected TopDocs nextTopDocs() throws IOException {
        Query rangeQuery = SearchBasedChangesSnapshot.rangeQuery(this.indexSettings, Math.max(this.fromSeqNo, this.lastSeenSeqNo), this.toSeqNo);
        SortField sortBySeqNo = new SortField("_seq_no", SortField.Type.LONG);
        TopFieldCollectorManager collectorManager = new TopFieldCollectorManager(new Sort(sortBySeqNo), this.searchBatchSize, this.afterDoc, 0);
        TopDocs results = this.indexSearcher.search(rangeQuery, collectorManager);
        if (results.scoreDocs.length > 0) {
            this.afterDoc = (FieldDoc)results.scoreDocs[results.scoreDocs.length - 1];
        }
        for (int i = 0; i < results.scoreDocs.length; ++i) {
            results.scoreDocs[i].shardIndex = i;
        }
        return results;
    }

    protected void setNextSourceMetadataReader(LeafReaderContext context) {
        if (this.sourceMetadataFetcher != null) {
            this.sourceMetadataFetcher.setNextReader(context);
        }
    }

    protected BytesReference addSourceMetadata(BytesReference originalSourceBytes, int segmentDocID) throws IOException {
        if (this.sourceMetadataFetcher == null) {
            return originalSourceBytes;
        }
        Source originalSource = Source.fromBytes(originalSourceBytes);
        List<Object> values = this.sourceMetadataFetcher.fetchValues(originalSource, segmentDocID, List.of());
        if (values.isEmpty()) {
            return originalSourceBytes;
        }
        Map<String, Object> map = originalSource.source();
        map.put("_inference_fields", values.get(0));
        return Source.fromMap(map, originalSource.sourceContentType()).internalSourceRef();
    }

    static IndexSearcher newIndexSearcher(Engine.Searcher engineSearcher) throws IOException {
        return new IndexSearcher(Lucene.wrapAllDocsLive(engineSearcher.getDirectoryReader()));
    }

    static Query rangeQuery(IndexSettings indexSettings, long fromSeqNo, long toSeqNo) {
        Query seqNoQuery = SeqNoFieldMapper.rangeQueryForSeqNo(indexSettings.seqNoIndexOptions(), fromSeqNo, toSeqNo);
        return new BooleanQuery.Builder().add(seqNoQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(indexSettings.getIndexVersionCreated()), BooleanClause.Occur.MUST).build();
    }

    private void verifyRange(Translog.Operation op) {
        if (op == null && this.lastSeenSeqNo < this.toSeqNo) {
            throw new MissingHistoryOperationsException("Not all operations between from_seqno [" + this.fromSeqNo + "] and to_seqno [" + this.toSeqNo + "] found; prematurely terminated last_seen_seqno [" + this.lastSeenSeqNo + "]");
        }
        if (op != null && op.seqNo() != this.lastSeenSeqNo + 1L) {
            throw new MissingHistoryOperationsException("Not all operations between from_seqno [" + this.fromSeqNo + "] and to_seqno [" + this.toSeqNo + "] found; expected seqno [" + this.lastSeenSeqNo + "1]; found [" + String.valueOf(op) + "]");
        }
    }

    protected static boolean assertDocSoftDeleted(LeafReader leafReader, int segmentDocId) throws IOException {
        NumericDocValues docValues = leafReader.getNumericDocValues("__soft_deletes");
        if (docValues == null || !docValues.advanceExact(segmentDocId)) {
            throw new IllegalStateException("DocValues for field [__soft_deletes] is not found");
        }
        return docValues.longValue() == 1L;
    }
}

