/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.file;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.file.AbstractFileWatchingService;
import org.elasticsearch.gateway.GatewayService;

public abstract class MasterNodeFileWatchingService
extends AbstractFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MasterNodeFileWatchingService.class);
    private final ClusterService clusterService;
    private volatile boolean active = false;

    protected MasterNodeFileWatchingService(ClusterService clusterService, Path settingsDir) {
        super(settingsDir);
        this.clusterService = clusterService;
    }

    @Override
    protected void doStart() {
        this.active = this.filesExists(this.watchedFileDir().getParent());
        if (!this.active) {
            return;
        }
        if (DiscoveryNode.isMasterNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        this.active = false;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clusterChanged(ClusterChangedEvent event) {
        ClusterState clusterState = event.state();
        if (clusterState.nodes().isLocalNodeElectedMaster() && !clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            MasterNodeFileWatchingService masterNodeFileWatchingService = this;
            synchronized (masterNodeFileWatchingService) {
                if (!this.active) {
                    return;
                }
                if (this.watching()) {
                    this.refreshExistingFileStateIfNeeded(clusterState);
                    return;
                }
                this.startWatcher();
            }
        } else if (event.previousState().nodes().isLocalNodeElectedMaster()) {
            this.stopWatcher();
        }
    }

    private void refreshExistingFileStateIfNeeded(ClusterState clusterState) {
        if (this.shouldRefreshFileState(clusterState)) {
            try (Stream<Path> files = this.filesList(this.watchedFileDir());){
                FileTime time = FileTime.from(Instant.now());
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    this.filesSetLastModifiedTime((Path)it.next(), time);
                }
            }
            catch (IOException e) {
                logger.warn("encountered I/O error trying to update file settings timestamp", (Throwable)e);
            }
        }
    }

    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        return false;
    }
}

