/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.telemetry.metric.LongCounter;

public class ChildMemoryCircuitBreaker
implements CircuitBreaker {
    private volatile LimitAndOverhead limitAndOverhead;
    private final CircuitBreaker.Durability durability;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final Logger logger;
    private final HierarchyCircuitBreakerService parent;
    private final String name;
    private final LongCounter trippedCountMeter;
    public static final String CIRCUIT_BREAKER_TYPE_ATTRIBUTE = "type";

    public ChildMemoryCircuitBreaker(LongCounter trippedCountMeter, BreakerSettings settings, Logger logger, HierarchyCircuitBreakerService parent, String name) {
        this.name = name;
        this.limitAndOverhead = new LimitAndOverhead(settings.getLimit(), settings.getOverhead());
        this.durability = settings.getDurability();
        this.used = new AtomicLong(0L);
        this.trippedCount = new AtomicLong(0L);
        this.logger = logger;
        logger.trace(() -> Strings.format("creating ChildCircuitBreaker with settings %s", settings));
        this.parent = parent;
        this.trippedCountMeter = trippedCountMeter;
    }

    @Override
    public void circuitBreak(String fieldName, long bytesNeeded) {
        long memoryBytesLimit = this.limitAndOverhead.limit;
        this.trippedCount.incrementAndGet();
        this.trippedCountMeter.incrementBy(1L, Collections.singletonMap(CIRCUIT_BREAKER_TYPE_ATTRIBUTE, this.name));
        String message = "[" + this.name + "] Data too large, data for [" + fieldName + "] would be [" + bytesNeeded + "/" + String.valueOf(ByteSizeValue.ofBytes(bytesNeeded)) + "], which is larger than the limit of [" + memoryBytesLimit + "/" + String.valueOf(ByteSizeValue.ofBytes(memoryBytesLimit)) + "]; for more information, see " + String.valueOf((Object)ReferenceDocs.CIRCUIT_BREAKER_ERRORS);
        this.logger.debug(() -> Strings.format("%s", message));
        throw new CircuitBreakingException(message, bytesNeeded, memoryBytesLimit, this.durability);
    }

    @Override
    public void addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        LimitAndOverhead limitAndOverhead = this.limitAndOverhead;
        long memoryBytesLimit = limitAndOverhead.limit;
        double overheadConstant = limitAndOverhead.overhead;
        if (memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes);
        }
        long newUsed = memoryBytesLimit == -1L ? this.noLimit(bytes, label) : this.limit(bytes, label, overheadConstant, memoryBytesLimit);
        try {
            this.parent.checkParentLimit((long)((double)bytes * overheadConstant), label);
        }
        catch (CircuitBreakingException e) {
            this.addWithoutBreaking(-bytes);
            throw e;
        }
        assert (newUsed >= 0L) : "Used bytes: [" + newUsed + "] must be >= 0";
    }

    private long noLimit(long bytes, String label) {
        long newUsed = this.used.addAndGet(bytes);
        this.logger.trace(() -> Strings.format("[%s] Adding [%s][%s] to used bytes [new used: [%s], limit: [-1b]]", this.name, ByteSizeValue.ofBytes(bytes), label, ByteSizeValue.ofBytes(newUsed)));
        return newUsed;
    }

    private long limit(long bytes, String label, double overheadConstant, long memoryBytesLimit) {
        long newUsed;
        long currentUsed;
        do {
            currentUsed = this.used.get();
            newUsed = currentUsed + bytes;
            long newUsedWithOverhead = (long)((double)newUsed * overheadConstant);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}], estimate: {} [{}]]", (Object)this.name, (Object)ByteSizeValue.ofBytes(bytes), (Object)label, (Object)ByteSizeValue.ofBytes(newUsed), (Object)memoryBytesLimit, (Object)ByteSizeValue.ofBytes(memoryBytesLimit), (Object)newUsedWithOverhead, (Object)ByteSizeValue.ofBytes(newUsedWithOverhead));
            }
            if (memoryBytesLimit <= 0L || newUsedWithOverhead <= memoryBytesLimit) continue;
            this.logger.warn("[{}] New used memory {} [{}] for data of [{}] would be larger than configured breaker: {} [{}], breaking", (Object)this.name, (Object)newUsedWithOverhead, (Object)ByteSizeValue.ofBytes(newUsedWithOverhead), (Object)label, (Object)memoryBytesLimit, (Object)ByteSizeValue.ofBytes(memoryBytesLimit));
            this.circuitBreak(label, newUsedWithOverhead);
        } while (!this.used.compareAndSet(currentUsed, newUsed));
        return newUsed;
    }

    @Override
    public void addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adjusted breaker by [{}] bytes, now [{}]", (Object)this.name, (Object)bytes, (Object)u);
        }
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.limitAndOverhead.limit;
    }

    @Override
    public double getOverhead() {
        return this.limitAndOverhead.overhead;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    @Override
    public void setLimitAndOverhead(long limit, double overhead) {
        this.limitAndOverhead = new LimitAndOverhead(limit, overhead);
    }

    private static class LimitAndOverhead {
        private final long limit;
        private final double overhead;

        LimitAndOverhead(long limit, double overhead) {
            this.limit = limit;
            this.overhead = overhead;
        }
    }
}

