/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.resolve.ResolveClusterInfo;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ResolveClusterActionResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField CONNECTED_FIELD = new ParseField("connected", new String[0]);
    private static final ParseField SKIP_UNAVAILABLE_FIELD = new ParseField("skip_unavailable", new String[0]);
    private static final ParseField MATCHING_INDICES_FIELD = new ParseField("matching_indices", new String[0]);
    private static final ParseField ES_VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    private final Map<String, ResolveClusterInfo> infoMap;

    public ResolveClusterActionResponse(Map<String, ResolveClusterInfo> infoMap) {
        this.infoMap = infoMap;
    }

    public ResolveClusterActionResponse(StreamInput in) throws IOException {
        this.infoMap = in.readImmutableMap(ResolveClusterInfo::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            throw new UnsupportedOperationException("ResolveClusterAction requires at least version " + TransportVersions.V_8_13_0.toReleaseVersion() + " but was " + out.getTransportVersion().toReleaseVersion());
        }
        out.writeMap(this.infoMap, StreamOutput::writeWriteable);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, ResolveClusterInfo> entry : this.infoMap.entrySet()) {
            Build build;
            String clusterAlias = entry.getKey();
            if (clusterAlias.equals("")) {
                clusterAlias = "(local)";
            }
            builder.startObject(clusterAlias);
            ResolveClusterInfo clusterInfo = entry.getValue();
            builder.field(CONNECTED_FIELD.getPreferredName(), clusterInfo.isConnected());
            builder.field(SKIP_UNAVAILABLE_FIELD.getPreferredName(), clusterInfo.getSkipUnavailable());
            if (clusterInfo.getError() != null) {
                builder.field(ERROR_FIELD.getPreferredName(), clusterInfo.getError());
            }
            if (clusterInfo.getMatchingIndices() != null) {
                builder.field(MATCHING_INDICES_FIELD.getPreferredName(), clusterInfo.getMatchingIndices());
            }
            if ((build = clusterInfo.getBuild()) != null) {
                builder.startObject(ES_VERSION_FIELD.getPreferredName()).field("number", build.qualifiedVersion()).field("build_flavor", build.flavor()).field("minimum_wire_compatibility_version", build.minWireCompatVersion()).field("minimum_index_compatibility_version", build.minIndexCompatVersion()).endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveClusterActionResponse response = (ResolveClusterActionResponse)o;
        return this.infoMap.equals(response.infoMap);
    }

    public int hashCode() {
        return Objects.hash(this.infoMap);
    }

    public Map<String, ResolveClusterInfo> getResolveClusterInfo() {
        return this.infoMap;
    }
}

