/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.LongMetric;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class CCSTelemetrySnapshot
implements Writeable,
ToXContentFragment {
    private long totalCount;
    private long successCount;
    private final Map<String, Long> failureReasons;
    private final LongMetric.LongMetricValue took;
    private final LongMetric.LongMetricValue tookMrtTrue;
    private final LongMetric.LongMetricValue tookMrtFalse;
    private long remotesPerSearchMax;
    private double remotesPerSearchAvg;
    private long skippedRemotes;
    private final Map<String, Long> featureCounts;
    private final Map<String, Long> clientCounts;
    private final Map<String, PerClusterCCSTelemetry> byRemoteCluster;
    private boolean useMRT = true;

    public CCSTelemetrySnapshot(long totalCount, long successCount, Map<String, Long> failureReasons, LongMetric.LongMetricValue took, LongMetric.LongMetricValue tookMrtTrue, LongMetric.LongMetricValue tookMrtFalse, long remotesPerSearchMax, double remotesPerSearchAvg, long skippedRemotes, Map<String, Long> featureCounts, Map<String, Long> clientCounts, Map<String, PerClusterCCSTelemetry> byRemoteCluster) {
        this.totalCount = totalCount;
        this.successCount = successCount;
        this.failureReasons = failureReasons;
        this.took = took;
        this.tookMrtTrue = tookMrtTrue;
        this.tookMrtFalse = tookMrtFalse;
        this.remotesPerSearchMax = remotesPerSearchMax;
        this.remotesPerSearchAvg = remotesPerSearchAvg;
        this.skippedRemotes = skippedRemotes;
        this.featureCounts = featureCounts;
        this.clientCounts = clientCounts;
        this.byRemoteCluster = byRemoteCluster;
    }

    public CCSTelemetrySnapshot() {
        this.failureReasons = new HashMap<String, Long>();
        this.featureCounts = new HashMap<String, Long>();
        this.clientCounts = new HashMap<String, Long>();
        this.byRemoteCluster = new HashMap<String, PerClusterCCSTelemetry>();
        this.took = new LongMetric.LongMetricValue();
        this.tookMrtTrue = new LongMetric.LongMetricValue();
        this.tookMrtFalse = new LongMetric.LongMetricValue();
    }

    public CCSTelemetrySnapshot(StreamInput in) throws IOException {
        this.totalCount = in.readVLong();
        this.successCount = in.readVLong();
        this.failureReasons = in.readMap(StreamInput::readLong);
        this.took = LongMetric.LongMetricValue.fromStream(in);
        this.tookMrtTrue = LongMetric.LongMetricValue.fromStream(in);
        this.tookMrtFalse = LongMetric.LongMetricValue.fromStream(in);
        this.remotesPerSearchMax = in.readVLong();
        this.remotesPerSearchAvg = in.readDouble();
        this.skippedRemotes = in.readVLong();
        this.featureCounts = in.readMap(StreamInput::readLong);
        this.clientCounts = in.readMap(StreamInput::readLong);
        this.byRemoteCluster = in.readMap(PerClusterCCSTelemetry::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCount);
        out.writeVLong(this.successCount);
        out.writeMap(this.failureReasons, StreamOutput::writeLong);
        this.took.writeTo(out);
        this.tookMrtTrue.writeTo(out);
        this.tookMrtFalse.writeTo(out);
        out.writeVLong(this.remotesPerSearchMax);
        out.writeDouble(this.remotesPerSearchAvg);
        out.writeVLong(this.skippedRemotes);
        out.writeMap(this.featureCounts, StreamOutput::writeLong);
        out.writeMap(this.clientCounts, StreamOutput::writeLong);
        out.writeMap(this.byRemoteCluster, StreamOutput::writeWriteable);
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public Map<String, Long> getFailureReasons() {
        return Collections.unmodifiableMap(this.failureReasons);
    }

    public LongMetric.LongMetricValue getTook() {
        return this.took;
    }

    public LongMetric.LongMetricValue getTookMrtTrue() {
        return this.tookMrtTrue;
    }

    public LongMetric.LongMetricValue getTookMrtFalse() {
        return this.tookMrtFalse;
    }

    public long getRemotesPerSearchMax() {
        return this.remotesPerSearchMax;
    }

    public double getRemotesPerSearchAvg() {
        return this.remotesPerSearchAvg;
    }

    public long getSearchCountWithSkippedRemotes() {
        return this.skippedRemotes;
    }

    public Map<String, Long> getFeatureCounts() {
        return Collections.unmodifiableMap(this.featureCounts);
    }

    public Map<String, Long> getClientCounts() {
        return Collections.unmodifiableMap(this.clientCounts);
    }

    public Map<String, PerClusterCCSTelemetry> getByRemoteCluster() {
        return Collections.unmodifiableMap(this.byRemoteCluster);
    }

    public CCSTelemetrySnapshot setUseMRT(boolean useMRT) {
        this.useMRT = useMRT;
        return this;
    }

    public void add(CCSTelemetrySnapshot stats) {
        if (stats == null || stats.totalCount == 0L) {
            return;
        }
        long oldCount = this.totalCount;
        this.totalCount += stats.totalCount;
        this.successCount += stats.successCount;
        this.skippedRemotes += stats.skippedRemotes;
        stats.failureReasons.forEach((k, v) -> this.failureReasons.merge((String)k, (Long)v, Long::sum));
        stats.featureCounts.forEach((k, v) -> this.featureCounts.merge((String)k, (Long)v, Long::sum));
        stats.clientCounts.forEach((k, v) -> this.clientCounts.merge((String)k, (Long)v, Long::sum));
        this.took.add(stats.took);
        if (this.useMRT) {
            this.tookMrtTrue.add(stats.tookMrtTrue);
            this.tookMrtFalse.add(stats.tookMrtFalse);
        }
        this.remotesPerSearchMax = Math.max(this.remotesPerSearchMax, stats.remotesPerSearchMax);
        this.remotesPerSearchAvg = this.totalCount > 0L && oldCount > 0L ? (this.remotesPerSearchAvg * (double)oldCount + stats.remotesPerSearchAvg * (double)stats.totalCount) / (double)this.totalCount : stats.remotesPerSearchAvg;
        stats.byRemoteCluster.forEach((r, v) -> this.byRemoteCluster.merge((String)r, new PerClusterCCSTelemetry((PerClusterCCSTelemetry)v), PerClusterCCSTelemetry::add));
    }

    private static void publishLatency(XContentBuilder builder, String name, LongMetric.LongMetricValue took) throws IOException {
        builder.startObject(name);
        builder.field("max", took.max());
        builder.field("avg", took.avg());
        builder.field("p90", took.p90());
        builder.endObject();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("total", this.totalCount);
        builder.field("success", this.successCount);
        builder.field("skipped", this.skippedRemotes);
        CCSTelemetrySnapshot.publishLatency(builder, "took", this.took);
        if (this.useMRT) {
            CCSTelemetrySnapshot.publishLatency(builder, "took_mrt_true", this.tookMrtTrue);
            CCSTelemetrySnapshot.publishLatency(builder, "took_mrt_false", this.tookMrtFalse);
        }
        builder.field("remotes_per_search_max", this.remotesPerSearchMax);
        builder.field("remotes_per_search_avg", this.remotesPerSearchAvg);
        builder.field("failure_reasons", this.failureReasons);
        builder.field("features", this.featureCounts);
        builder.field("clients", this.clientCounts);
        builder.startObject("clusters");
        for (Map.Entry<String, PerClusterCCSTelemetry> entry : this.byRemoteCluster.entrySet()) {
            String remoteName = entry.getKey();
            if ("".equals(remoteName)) {
                remoteName = "(local)";
            }
            builder.field(remoteName, entry.getValue());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCSTelemetrySnapshot that = (CCSTelemetrySnapshot)o;
        return this.totalCount == that.totalCount && this.successCount == that.successCount && this.skippedRemotes == that.skippedRemotes && Objects.equals(this.failureReasons, that.failureReasons) && Objects.equals(this.took, that.took) && Objects.equals(this.tookMrtTrue, that.tookMrtTrue) && Objects.equals(this.tookMrtFalse, that.tookMrtFalse) && Objects.equals(this.remotesPerSearchMax, that.remotesPerSearchMax) && Objects.equals(this.remotesPerSearchAvg, that.remotesPerSearchAvg) && Objects.equals(this.featureCounts, that.featureCounts) && Objects.equals(this.clientCounts, that.clientCounts) && Objects.equals(this.byRemoteCluster, that.byRemoteCluster);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.successCount, this.failureReasons, this.took, this.tookMrtTrue, this.tookMrtFalse, this.remotesPerSearchMax, this.remotesPerSearchAvg, this.skippedRemotes, this.featureCounts, this.clientCounts, this.byRemoteCluster);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static class PerClusterCCSTelemetry
    implements Writeable,
    ToXContentFragment {
        private long count;
        private long skippedCount;
        private final LongMetric.LongMetricValue took;

        public PerClusterCCSTelemetry() {
            this.took = new LongMetric.LongMetricValue();
        }

        public PerClusterCCSTelemetry(long count, long skippedCount, LongMetric.LongMetricValue took) {
            this.took = took;
            this.skippedCount = skippedCount;
            this.count = count;
        }

        public PerClusterCCSTelemetry(PerClusterCCSTelemetry other) {
            this.count = other.count;
            this.skippedCount = other.skippedCount;
            this.took = new LongMetric.LongMetricValue(other.took);
        }

        public PerClusterCCSTelemetry(StreamInput in) throws IOException {
            this.count = in.readVLong();
            this.skippedCount = in.readVLong();
            this.took = LongMetric.LongMetricValue.fromStream(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.count);
            out.writeVLong(this.skippedCount);
            this.took.writeTo(out);
        }

        public PerClusterCCSTelemetry add(PerClusterCCSTelemetry v) {
            this.count += v.count;
            this.skippedCount += v.skippedCount;
            this.took.add(v.took);
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("total", this.count);
            builder.field("skipped", this.skippedCount);
            CCSTelemetrySnapshot.publishLatency(builder, "took", this.took);
            builder.endObject();
            return builder;
        }

        public long getCount() {
            return this.count;
        }

        public long getSkippedCount() {
            return this.skippedCount;
        }

        public LongMetric.LongMetricValue getTook() {
            return this.took;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerClusterCCSTelemetry that = (PerClusterCCSTelemetry)o;
            return this.count == that.count && this.skippedCount == that.skippedCount && Objects.equals(this.took, that.took);
        }

        public int hashCode() {
            return Objects.hash(this.count, this.skippedCount, this.took);
        }

        public String toString() {
            return Strings.toString(this, true, true);
        }
    }
}

