/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import org.apache.lucene.analysis.morph.BinaryDictionary;
import org.apache.lucene.analysis.morph.ConnectionCosts;
import org.apache.lucene.analysis.morph.Dictionary;
import org.apache.lucene.analysis.morph.MorphData;
import org.apache.lucene.analysis.morph.Token;
import org.apache.lucene.analysis.morph.TokenInfoFST;
import org.apache.lucene.analysis.morph.TokenType;
import org.apache.lucene.analysis.morph.Viterbi;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntIntHashMap;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.fst.FST;

public abstract class ViterbiNBest<T extends Token, U extends MorphData>
extends Viterbi<T, PositionNBest> {
    protected final EnumMap<TokenType, Dictionary<? extends U>> dictionaryMap = new EnumMap(TokenType.class);
    private int nBestCost = 0;
    protected Lattice<U> lattice = null;

    protected ViterbiNBest(TokenInfoFST fst, FST.BytesReader fstReader, BinaryDictionary<? extends MorphData> dictionary, TokenInfoFST userFST, FST.BytesReader userFSTReader, Dictionary<? extends MorphData> userDictionary, ConnectionCosts costs) {
        super(fst, fstReader, dictionary, userFST, userFSTReader, userDictionary, costs, PositionNBest.class);
    }

    @Override
    protected final void backtraceNBest(Viterbi.Position endPosData, boolean useEOS) throws IOException {
        int cost;
        IntArrayList nbest;
        if (this.lattice == null) {
            this.lattice = new Lattice();
        }
        int endPos = endPosData.getPos();
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        this.lattice.setup(fragment, this.dictionaryMap, this.positions, this.lastBackTracePos, endPos, useEOS);
        this.lattice.markUnreachable();
        this.lattice.calcLeftCost(this.costs);
        this.lattice.calcRightCost(this.costs);
        int bestCost = this.lattice.bestCost();
        for (IntCursor node : this.lattice.bestPathNodeList()) {
            this.registerNode(node.value, fragment);
        }
        int n = 2;
        while (!(nbest = this.lattice.nBestNodeList(n)).isEmpty() && bestCost + this.nBestCost >= (cost = this.lattice.cost(nbest.get(0)))) {
            for (IntCursor node : nbest) {
                this.registerNode(node.value, fragment);
            }
            ++n;
        }
    }

    protected abstract void registerNode(int var1, char[] var2);

    @Override
    protected final void fixupPendingList() {
        Collections.sort(this.pending, (a, b) -> {
            int bLen;
            int bOff;
            int aOff = a.getOffset();
            if (aOff != (bOff = b.getOffset())) {
                return aOff - bOff;
            }
            int aLen = a.getLength();
            if (aLen != (bLen = b.getLength())) {
                return aLen - bLen;
            }
            return b.getType().ordinal() - a.getType().ordinal();
        });
        for (int i = 1; i < this.pending.size(); ++i) {
            Token a2 = (Token)this.pending.get(i - 1);
            Token b2 = (Token)this.pending.get(i);
            if (a2.getOffset() != b2.getOffset() || a2.getLength() != b2.getLength()) continue;
            this.pending.remove(i);
            --i;
        }
        IntIntHashMap map = new IntIntHashMap();
        for (Token t : this.pending) {
            map.put(t.getOffset(), 0);
            map.put(t.getOffset() + t.getLength(), 0);
        }
        int[] offsets = map.keys().toArray();
        Arrays.sort(offsets);
        for (int i = 0; i < offsets.length; ++i) {
            map.put(offsets[i], i);
        }
        for (Token t : this.pending) {
            t.setPositionLength(map.get(t.getOffset() + t.getLength()) - map.get(t.getOffset()));
        }
        Collections.reverse(this.pending);
    }

    protected void setNBestCost(int value) {
        this.nBestCost = value;
        this.outputNBest = 0 < this.nBestCost;
    }

    protected int getNBestCost() {
        return this.nBestCost;
    }

    public int getLatticeRootBase() {
        return this.lattice.getRootBase();
    }

    public int probeDelta(int start, int end) {
        return this.lattice.probeDelta(start, end);
    }

    public static final class PositionNBest
    extends Viterbi.Position {
        int forwardCount;
        int[] forwardPos = new int[8];
        int[] forwardID = new int[8];
        int[] forwardIndex = new int[8];
        TokenType[] forwardType = new TokenType[8];

        private void growForward() {
            this.forwardPos = ArrayUtil.grow(this.forwardPos, 1 + this.forwardCount);
            this.forwardID = ArrayUtil.grow(this.forwardID, 1 + this.forwardCount);
            this.forwardIndex = ArrayUtil.grow(this.forwardIndex, 1 + this.forwardCount);
            TokenType[] newForwardType = new TokenType[this.forwardPos.length];
            System.arraycopy(this.forwardType, 0, newForwardType, 0, this.forwardType.length);
            this.forwardType = newForwardType;
        }

        public void addForward(int forwardPos, int forwardIndex, int forwardID, TokenType forwardType) {
            if (this.forwardCount == this.forwardID.length) {
                this.growForward();
            }
            this.forwardPos[this.forwardCount] = forwardPos;
            this.forwardIndex[this.forwardCount] = forwardIndex;
            this.forwardID[this.forwardCount] = forwardID;
            this.forwardType[this.forwardCount] = forwardType;
            ++this.forwardCount;
        }

        @Override
        public void reset() {
            super.reset();
            assert (this.forwardCount == 0) : "pos=" + this.getPos() + " forwardCount=" + this.forwardCount;
        }

        public int getForwardCount() {
            return this.forwardCount;
        }

        public void setForwardCount(int forwardCount) {
            this.forwardCount = forwardCount;
        }

        public TokenType getForwardType(int index) {
            return this.forwardType[index];
        }

        public int getForwardID(int index) {
            return this.forwardID[index];
        }

        public int getForwardPos(int index) {
            return this.forwardPos[index];
        }
    }

    protected static final class Lattice<U extends MorphData> {
        private char[] fragment;
        private EnumMap<TokenType, Dictionary<? extends U>> dictionaryMap;
        private boolean useEOS;
        private int rootCapacity = 0;
        private int rootSize = 0;
        private int rootBase = 0;
        private int[] lRoot;
        private int[] rRoot;
        private int capacity = 0;
        private int nodeCount = 0;
        private TokenType[] nodeDicType;
        private int[] nodeWordID;
        private int[] nodeMark;
        private int[] nodeLeftID;
        private int[] nodeRightID;
        private int[] nodeWordCost;
        private int[] nodeLeftCost;
        private int[] nodeRightCost;
        private int[] nodeLeftNode;
        private int[] nodeRightNode;
        private int[] nodeLeft;
        private int[] nodeRight;
        private int[] nodeLeftChain;
        private int[] nodeRightChain;

        protected Lattice() {
        }

        public int getNodeLeft(int node) {
            return this.nodeLeft[node];
        }

        public int getNodeRight(int node) {
            return this.nodeRight[node];
        }

        public TokenType getNodeDicType(int node) {
            return this.nodeDicType[node];
        }

        public int getNodeWordID(int node) {
            return this.nodeWordID[node];
        }

        public int getRootBase() {
            return this.rootBase;
        }

        private void setupRoot(int baseOffset, int lastOffset) {
            assert (baseOffset <= lastOffset);
            int size = lastOffset - baseOffset + 1;
            if (this.rootCapacity < size) {
                int oversize = ArrayUtil.oversize(size, 4);
                this.lRoot = new int[oversize];
                this.rRoot = new int[oversize];
                this.rootCapacity = oversize;
            }
            Arrays.fill(this.lRoot, 0, size, -1);
            Arrays.fill(this.rRoot, 0, size, -1);
            this.rootSize = size;
            this.rootBase = baseOffset;
        }

        private void reserve(int n) {
            if (this.capacity < n) {
                int oversize = ArrayUtil.oversize(n, 4);
                this.nodeDicType = new TokenType[oversize];
                this.nodeWordID = new int[oversize];
                this.nodeMark = new int[oversize];
                this.nodeLeftID = new int[oversize];
                this.nodeRightID = new int[oversize];
                this.nodeWordCost = new int[oversize];
                this.nodeLeftCost = new int[oversize];
                this.nodeRightCost = new int[oversize];
                this.nodeLeftNode = new int[oversize];
                this.nodeRightNode = new int[oversize];
                this.nodeLeft = new int[oversize];
                this.nodeRight = new int[oversize];
                this.nodeLeftChain = new int[oversize];
                this.nodeRightChain = new int[oversize];
                this.capacity = oversize;
            }
        }

        private void setupNodePool(int n) {
            this.reserve(n);
            this.nodeCount = 0;
        }

        private int addNode(TokenType dicType, int wordID, int left, int right) {
            assert (this.nodeCount < this.capacity);
            assert (left == -1 || right == -1 || left < right);
            assert (left == -1 || 0 <= left && left < this.rootSize);
            assert (right == -1 || 0 <= right && right < this.rootSize);
            int node = this.nodeCount++;
            this.nodeDicType[node] = dicType;
            this.nodeWordID[node] = wordID;
            this.nodeMark[node] = 0;
            if (wordID < 0) {
                this.nodeWordCost[node] = 0;
                this.nodeLeftCost[node] = 0;
                this.nodeRightCost[node] = 0;
                this.nodeLeftID[node] = 0;
                this.nodeRightID[node] = 0;
            } else {
                Dictionary<U> dic = this.dictionaryMap.get((Object)dicType);
                this.nodeWordCost[node] = dic.getWordCost(wordID);
                this.nodeLeftID[node] = dic.getLeftId(wordID);
                this.nodeRightID[node] = dic.getRightId(wordID);
            }
            this.nodeLeft[node] = left;
            this.nodeRight[node] = right;
            if (0 <= left) {
                this.nodeLeftChain[node] = this.lRoot[left];
                this.lRoot[left] = node;
            } else {
                this.nodeLeftChain[node] = -1;
            }
            if (0 <= right) {
                this.nodeRightChain[node] = this.rRoot[right];
                this.rRoot[right] = node;
            } else {
                this.nodeRightChain[node] = -1;
            }
            return node;
        }

        private int positionCount(Viterbi.WrappedPositionArray<PositionNBest> positions, int beg, int end) {
            int count = 0;
            for (int i = beg; i < end; ++i) {
                count += positions.get(i).getCount();
            }
            return count;
        }

        void setup(char[] fragment, EnumMap<TokenType, Dictionary<? extends U>> dictionaryMap, Viterbi.WrappedPositionArray<PositionNBest> positions, int prevOffset, int endOffset, boolean useEOS) {
            assert (positions.get(prevOffset).getCount() == 1);
            this.fragment = fragment;
            this.dictionaryMap = dictionaryMap;
            this.useEOS = useEOS;
            this.setupRoot(prevOffset, endOffset);
            this.setupNodePool(this.positionCount(positions, prevOffset + 1, endOffset + 1) + 2);
            PositionNBest first = positions.get(prevOffset);
            if (this.addNode(first.getBackType(0), first.getBackID(0), -1, 0) != 0) assert (false);
            if (this.addNode(TokenType.KNOWN, -1, endOffset - this.rootBase, -1) != 1) assert (false);
            for (int offset = endOffset; prevOffset < offset; --offset) {
                int right = offset - this.rootBase;
                if (0 > this.lRoot[right]) continue;
                PositionNBest pos = positions.get(offset);
                for (int i = 0; i < pos.getCount(); ++i) {
                    this.addNode(pos.getBackType(i), pos.getBackID(i), pos.getBackPos(i) - this.rootBase, right);
                }
            }
        }

        void markUnreachable() {
            for (int index = 1; index < this.rootSize - 1; ++index) {
                if (this.rRoot[index] >= 0) continue;
                int node = this.lRoot[index];
                while (0 <= node) {
                    this.nodeMark[node] = -1;
                    node = this.nodeLeftChain[node];
                }
            }
        }

        private int connectionCost(ConnectionCosts costs, int left, int right) {
            int leftID = this.nodeLeftID[right];
            return leftID == 0 && !this.useEOS ? 0 : costs.get(this.nodeRightID[left], leftID);
        }

        void calcLeftCost(ConnectionCosts costs) {
            for (int index = 0; index < this.rootSize; ++index) {
                int node = this.lRoot[index];
                while (0 <= node) {
                    if (0 <= this.nodeMark[node]) {
                        int leastNode = -1;
                        int leastCost = Integer.MAX_VALUE;
                        int leftNode = this.rRoot[index];
                        while (0 <= leftNode) {
                            int cost;
                            if (0 <= this.nodeMark[leftNode] && (cost = this.nodeLeftCost[leftNode] + this.nodeWordCost[leftNode] + this.connectionCost(costs, leftNode, node)) < leastCost) {
                                leastCost = cost;
                                leastNode = leftNode;
                            }
                            leftNode = this.nodeRightChain[leftNode];
                        }
                        assert (0 <= leastNode);
                        this.nodeLeftNode[node] = leastNode;
                        this.nodeLeftCost[node] = leastCost;
                    }
                    node = this.nodeLeftChain[node];
                }
            }
        }

        void calcRightCost(ConnectionCosts costs) {
            for (int index = this.rootSize - 1; 0 <= index; --index) {
                int node = this.rRoot[index];
                while (0 <= node) {
                    if (0 <= this.nodeMark[node]) {
                        int leastNode = -1;
                        int leastCost = Integer.MAX_VALUE;
                        int rightNode = this.lRoot[index];
                        while (0 <= rightNode) {
                            int cost;
                            if (0 <= this.nodeMark[rightNode] && (cost = this.nodeRightCost[rightNode] + this.nodeWordCost[rightNode] + this.connectionCost(costs, node, rightNode)) < leastCost) {
                                leastCost = cost;
                                leastNode = rightNode;
                            }
                            rightNode = this.nodeLeftChain[rightNode];
                        }
                        assert (0 <= leastNode);
                        this.nodeRightNode[node] = leastNode;
                        this.nodeRightCost[node] = leastCost;
                    }
                    node = this.nodeRightChain[node];
                }
            }
        }

        void markSameSpanNode(int refNode, int value) {
            int left = this.nodeLeft[refNode];
            int right = this.nodeRight[refNode];
            int node = this.lRoot[left];
            while (0 <= node) {
                if (this.nodeRight[node] == right) {
                    this.nodeMark[node] = value;
                }
                node = this.nodeLeftChain[node];
            }
        }

        IntArrayList bestPathNodeList() {
            IntArrayList list = new IntArrayList();
            int node = this.nodeRightNode[0];
            while (node != 1) {
                list.add(node);
                this.markSameSpanNode(node, 1);
                node = this.nodeRightNode[node];
            }
            return list;
        }

        private int cost(int node) {
            return this.nodeLeftCost[node] + this.nodeWordCost[node] + this.nodeRightCost[node];
        }

        IntArrayList nBestNodeList(int N) {
            IntArrayList list = new IntArrayList();
            int leastCost = Integer.MAX_VALUE;
            int leastLeft = -1;
            int leastRight = -1;
            for (int node = 2; node < this.nodeCount; ++node) {
                if (this.nodeMark[node] != 0) continue;
                int cost = this.cost(node);
                if (cost < leastCost) {
                    leastCost = cost;
                    leastLeft = this.nodeLeft[node];
                    leastRight = this.nodeRight[node];
                    list.clear();
                    list.add(node);
                    continue;
                }
                if (cost != leastCost || this.nodeLeft[node] == leastLeft && this.nodeRight[node] == leastRight) continue;
                list.add(node);
            }
            for (IntCursor node : list) {
                this.markSameSpanNode(node.value, N);
            }
            return list;
        }

        int bestCost() {
            return this.nodeLeftCost[1];
        }

        int probeDelta(int start, int end) {
            int left = start - this.rootBase;
            int right = end - this.rootBase;
            if (left < 0 || this.rootSize < right) {
                return Integer.MAX_VALUE;
            }
            int probedCost = Integer.MAX_VALUE;
            int node = this.lRoot[left];
            while (0 <= node) {
                if (this.nodeRight[node] == right) {
                    probedCost = Math.min(probedCost, this.cost(node));
                }
                node = this.nodeLeftChain[node];
            }
            return probedCost - this.bestCost();
        }

        void debugPrint() {
        }
    }
}

