/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.get_memory_stats;

import co.elastic.clients.elasticsearch.ml.get_memory_stats.JvmStats;
import co.elastic.clients.elasticsearch.ml.get_memory_stats.MemStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Memory
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final JvmStats jvm;
    private final MemStats mem;
    private final String name;
    private final List<String> roles;
    private final String transportAddress;
    private final String ephemeralId;
    public static final JsonpDeserializer<Memory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Memory::setupMemoryDeserializer);

    private Memory(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.jvm = ApiTypeHelper.requireNonNull(builder.jvm, this, "jvm");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.ephemeralId = ApiTypeHelper.requireNonNull(builder.ephemeralId, this, "ephemeralId");
    }

    public static Memory of(Function<Builder, ObjectBuilder<Memory>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final JvmStats jvm() {
        return this.jvm;
    }

    public final MemStats mem() {
        return this.mem;
    }

    public final String name() {
        return this.name;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final String ephemeralId() {
        return this.ephemeralId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("jvm");
        this.jvm.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::jvm, JvmStats._DESERIALIZER, "jvm");
        op.add(Builder::mem, MemStats._DESERIALIZER, "mem");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Memory> {
        private Map<String, String> attributes;
        private JvmStats jvm;
        private MemStats mem;
        private String name;
        private List<String> roles;
        private String transportAddress;
        private String ephemeralId;

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder jvm(JvmStats value) {
            this.jvm = value;
            return this;
        }

        public final Builder jvm(Function<JvmStats.Builder, ObjectBuilder<JvmStats>> fn) {
            return this.jvm(fn.apply(new JvmStats.Builder()).build());
        }

        public final Builder mem(MemStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<MemStats.Builder, ObjectBuilder<MemStats>> fn) {
            return this.mem(fn.apply(new MemStats.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Memory build() {
            this._checkSingleUse();
            return new Memory(this);
        }
    }
}

