/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.inference.results.XContentFormattedException;

public class UnifiedChatCompletionException
extends XContentFormattedException {
    private static final Logger log = LogManager.getLogger(UnifiedChatCompletionException.class);
    private final String message;
    private final String type;
    @Nullable
    private final String code;
    @Nullable
    private final String param;

    public UnifiedChatCompletionException(RestStatus status, String message, String type, @Nullable String code) {
        this(status, message, type, code, null);
    }

    public UnifiedChatCompletionException(RestStatus status, String message, String type, @Nullable String code, @Nullable String param) {
        super(message, status);
        this.message = Objects.requireNonNull(message);
        this.type = Objects.requireNonNull(type);
        this.code = code;
        this.param = param;
    }

    public UnifiedChatCompletionException(Throwable cause, RestStatus status, String message, String type, @Nullable String code, @Nullable String param) {
        super(message, cause, status);
        this.message = Objects.requireNonNull(message);
        this.type = Objects.requireNonNull(type);
        this.code = code;
        this.param = param;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.startObject("error"), UnifiedChatCompletionException.optionalField("code", this.code), UnifiedChatCompletionException.field("message", this.message), UnifiedChatCompletionException.optionalField("param", this.param), UnifiedChatCompletionException.field("type", this.type), ChunkedToXContentHelper.endObject(), ChunkedToXContentHelper.endObject());
    }

    private static Iterator<ToXContent> field(String key, String value) {
        return ChunkedToXContentHelper.chunk((b, p) -> b.field(key, value));
    }

    private static Iterator<ToXContent> optionalField(String key, String value) {
        return value != null ? ChunkedToXContentHelper.chunk((b, p) -> b.field(key, value)) : Collections.emptyIterator();
    }

    public static UnifiedChatCompletionException fromThrowable(Throwable t) {
        Throwable throwable = ExceptionsHelper.unwrapCause(t);
        if (throwable instanceof UnifiedChatCompletionException) {
            UnifiedChatCompletionException e = (UnifiedChatCompletionException)throwable;
            return e;
        }
        return ExceptionsHelper.maybeError(t).map(error -> {
            ExceptionsHelper.maybeDieOnAnotherThread(error);
            RuntimeException e = new RuntimeException("Fatal error while streaming response. Please retry the request.");
            log.error(e.getMessage(), t);
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage(), UnifiedChatCompletionException.getExceptionName(e), RestStatus.INTERNAL_SERVER_ERROR.name().toLowerCase(Locale.ROOT));
        }).orElseGet(() -> {
            log.atDebug().withThrowable(t).log("UnifiedChatCompletionException stack trace for debugging purposes.");
            RestStatus status = ExceptionsHelper.status(t);
            return new UnifiedChatCompletionException(t, status, t.getMessage(), UnifiedChatCompletionException.getExceptionName(t), status.name().toLowerCase(Locale.ROOT), null);
        });
    }
}

