/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.scanners;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.plugins.scanners.ExtensibleFileReader;

public class ExtensiblesRegistry {
    private static final Logger logger = LogManager.getLogger(ExtensiblesRegistry.class);
    private static final String EXTENSIBLES_FILE = "/org/elasticsearch/plugins/scanners/extensibles.json";
    public static final ExtensiblesRegistry INSTANCE = new ExtensiblesRegistry("/org/elasticsearch/plugins/scanners/extensibles.json");
    private final Map<String, String> loadedExtensible;

    ExtensiblesRegistry(String extensiblesFile) {
        ExtensibleFileReader extensibleFileReader = new ExtensibleFileReader(extensiblesFile);
        this.loadedExtensible = extensibleFileReader.readFromFile();
        if (this.loadedExtensible.size() > 0) {
            logger.debug(() -> Strings.format("Loaded extensible from cache file %s", this.loadedExtensible));
        }
    }

    public boolean hasExtensible(String extensibleName) {
        return this.loadedExtensible.containsKey(extensibleName);
    }
}

