/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.Strings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private static final String STRICT_JSON_PARSING_PARAMETER = "strict_json_parsing";
    private final String field;
    private final String targetField;
    private final boolean addToRoot;
    private final ConflictStrategy addToRootConflictStrategy;
    private final boolean allowDuplicateKeys;
    private final boolean strictJsonParsing;

    JsonProcessor(String tag, String description, String field, String targetField, boolean addToRoot, ConflictStrategy addToRootConflictStrategy, boolean allowDuplicateKeys) {
        this(tag, description, field, targetField, addToRoot, addToRootConflictStrategy, allowDuplicateKeys, true);
    }

    JsonProcessor(String tag, String description, String field, String targetField, boolean addToRoot, ConflictStrategy addToRootConflictStrategy, boolean allowDuplicateKeys, boolean strictJsonParsing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.addToRoot = addToRoot;
        this.addToRootConflictStrategy = addToRootConflictStrategy;
        this.allowDuplicateKeys = allowDuplicateKeys;
        this.strictJsonParsing = strictJsonParsing;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isAddToRoot() {
        return this.addToRoot;
    }

    public ConflictStrategy getAddToRootConflictStrategy() {
        return this.addToRootConflictStrategy;
    }

    public static Object apply(Object fieldValue, boolean allowDuplicateKeys, boolean strictJsonParsing) {
        String string;
        block25: {
            XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, fieldValue == null ? "null" : fieldValue.toString());
            try {
                parser.allowDuplicateKeys(allowDuplicateKeys);
                XContentParser.Token token = parser.nextToken();
                Object value = null;
                if (token == XContentParser.Token.VALUE_NULL) {
                    value = null;
                } else if (token == XContentParser.Token.VALUE_STRING) {
                    value = parser.text();
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    value = parser.numberValue();
                } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    value = parser.booleanValue();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    value = parser.map();
                } else if (token == XContentParser.Token.START_ARRAY) {
                    value = parser.list();
                } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    throw new IllegalArgumentException("cannot read binary value");
                }
                if (strictJsonParsing) {
                    String errorMessage = Strings.format("The input %s is not valid JSON and the %s parameter is true", fieldValue, STRICT_JSON_PARSING_PARAMETER);
                    try {
                        token = parser.nextToken();
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(errorMessage, e);
                    }
                    if (token != null) {
                        throw new IllegalArgumentException(errorMessage);
                    }
                }
                string = value;
                if (parser == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            parser.close();
        }
        return string;
    }

    public static void apply(Map<String, Object> ctx, String fieldName, boolean allowDuplicateKeys, ConflictStrategy conflictStrategy, boolean strictJsonParsing) {
        Object value = JsonProcessor.apply(ctx.get(fieldName), allowDuplicateKeys, strictJsonParsing);
        if (value instanceof Map) {
            Map map = (Map)value;
            if (conflictStrategy == ConflictStrategy.MERGE) {
                JsonProcessor.recursiveMerge(ctx, map);
            } else {
                ctx.putAll(map);
            }
        } else {
            throw new IllegalArgumentException("cannot add non-map fields to root of document");
        }
    }

    public static void recursiveMerge(Map<String, Object> target, Map<String, Object> from) {
        for (String key : from.keySet()) {
            if (target.containsKey(key)) {
                Object targetValue = target.get(key);
                Object fromValue = from.get(key);
                if (targetValue instanceof Map && fromValue instanceof Map) {
                    Map targetMap = (Map)targetValue;
                    Map fromMap = (Map)fromValue;
                    JsonProcessor.recursiveMerge(targetMap, fromMap);
                    continue;
                }
                target.put(key, fromValue);
                continue;
            }
            target.put(key, from.get(key));
        }
    }

    @Override
    public IngestDocument execute(IngestDocument document) throws Exception {
        if (this.addToRoot) {
            JsonProcessor.apply(document.getSourceAndMetadata(), this.field, this.allowDuplicateKeys, this.addToRootConflictStrategy, this.strictJsonParsing);
        } else {
            document.setFieldValue(this.targetField, JsonProcessor.apply(document.getFieldValue(this.field, Object.class), this.allowDuplicateKeys, this.strictJsonParsing));
        }
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static enum ConflictStrategy {
        REPLACE,
        MERGE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static ConflictStrategy fromString(String conflictStrategy) {
            return ConflictStrategy.valueOf(conflictStrategy.toUpperCase(Locale.ROOT));
        }
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            ConflictStrategy addToRootConflictStrategy;
            boolean hasConflictStrategy;
            String field = ConfigurationUtils.readStringProperty(JsonProcessor.TYPE, processorTag, config, "field");
            String targetField = ConfigurationUtils.readOptionalStringProperty(JsonProcessor.TYPE, processorTag, config, "target_field");
            boolean addToRoot = ConfigurationUtils.readBooleanProperty(JsonProcessor.TYPE, processorTag, config, "add_to_root", false);
            boolean allowDuplicateKeys = ConfigurationUtils.readBooleanProperty(JsonProcessor.TYPE, processorTag, config, "allow_duplicate_keys", false);
            String conflictStrategyString = ConfigurationUtils.readOptionalStringProperty(JsonProcessor.TYPE, processorTag, config, "add_to_root_conflict_strategy");
            boolean bl = hasConflictStrategy = conflictStrategyString != null;
            if (conflictStrategyString == null) {
                conflictStrategyString = ConflictStrategy.REPLACE.name();
            }
            try {
                addToRootConflictStrategy = ConflictStrategy.fromString(conflictStrategyString);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException(JsonProcessor.TYPE, processorTag, "add_to_root_conflict_strategy", "conflict strategy [" + conflictStrategyString + "] not supported, cannot convert field.");
            }
            if (addToRoot && targetField != null) {
                throw ConfigurationUtils.newConfigurationException(JsonProcessor.TYPE, processorTag, "target_field", "Cannot set a target field while also setting `add_to_root` to true");
            }
            if (!addToRoot && hasConflictStrategy) {
                throw ConfigurationUtils.newConfigurationException(JsonProcessor.TYPE, processorTag, "add_to_root_conflict_strategy", "Cannot set `add_to_root_conflict_strategy` if `add_to_root` is false");
            }
            boolean strictParsing = ConfigurationUtils.readBooleanProperty(JsonProcessor.TYPE, processorTag, config, JsonProcessor.STRICT_JSON_PARSING_PARAMETER, true);
            if (targetField == null) {
                targetField = field;
            }
            return new JsonProcessor(processorTag, description, field, targetField, addToRoot, addToRootConflictStrategy, allowDuplicateKeys, strictParsing);
        }
    }
}

