/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class BufferNativeInvoker
extends NativeInvoker {
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final ParameterMarshaller[] parameterMarshallers;
    private final boolean needsInvocationSession;
    private final int postInvokeCount;
    private final int referenceCount;
    private final HeapInvocationBuffer dummyBuffer;

    BufferNativeInvoker(RubyModule implementationClass, Function function, Signature signature, FunctionInvoker functionInvoker, ParameterMarshaller[] parameterMarshallers) {
        super(implementationClass, function, signature);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.parameterMarshallers = (ParameterMarshaller[])parameterMarshallers.clone();
        int piCount = 0;
        int refCount = 0;
        for (ParameterMarshaller m : parameterMarshallers) {
            if (m.requiresPostInvoke()) {
                ++piCount;
            }
            if (!m.requiresReference()) continue;
            ++refCount;
        }
        this.postInvokeCount = piCount;
        this.referenceCount = refCount;
        this.needsInvocationSession = piCount > 0 || refCount > 0;
        this.dummyBuffer = new HeapInvocationBuffer(function);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
        return this.functionInvoker.invoke(context, this.function, this.dummyBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1) {
        HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
        if (this.needsInvocationSession) {
            Invocation invocation = new Invocation(context, this.postInvokeCount, this.referenceCount);
            try {
                this.parameterMarshallers[0].marshal(invocation, (InvocationBuffer)buffer, arg1);
                IRubyObject iRubyObject = this.functionInvoker.invoke(context, this.function, buffer);
                return iRubyObject;
            }
            finally {
                invocation.finish();
            }
        }
        this.parameterMarshallers[0].marshal(context, (InvocationBuffer)buffer, arg1);
        return this.functionInvoker.invoke(context, this.function, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
        if (this.needsInvocationSession) {
            Invocation invocation = new Invocation(context, this.postInvokeCount, this.referenceCount);
            try {
                this.parameterMarshallers[0].marshal(invocation, (InvocationBuffer)buffer, arg1);
                this.parameterMarshallers[1].marshal(invocation, (InvocationBuffer)buffer, arg2);
                IRubyObject iRubyObject = this.functionInvoker.invoke(context, this.function, buffer);
                return iRubyObject;
            }
            finally {
                invocation.finish();
            }
        }
        this.parameterMarshallers[0].marshal(context, (InvocationBuffer)buffer, arg1);
        this.parameterMarshallers[1].marshal(context, (InvocationBuffer)buffer, arg2);
        return this.functionInvoker.invoke(context, this.function, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
        if (this.needsInvocationSession) {
            Invocation invocation = new Invocation(context, this.postInvokeCount, this.referenceCount);
            try {
                this.parameterMarshallers[0].marshal(invocation, (InvocationBuffer)buffer, arg1);
                this.parameterMarshallers[1].marshal(invocation, (InvocationBuffer)buffer, arg2);
                this.parameterMarshallers[2].marshal(invocation, (InvocationBuffer)buffer, arg3);
                IRubyObject iRubyObject = this.functionInvoker.invoke(context, this.function, buffer);
                return iRubyObject;
            }
            finally {
                invocation.finish();
            }
        }
        this.parameterMarshallers[0].marshal(context, (InvocationBuffer)buffer, arg1);
        this.parameterMarshallers[1].marshal(context, (InvocationBuffer)buffer, arg2);
        this.parameterMarshallers[2].marshal(context, (InvocationBuffer)buffer, arg3);
        return this.functionInvoker.invoke(context, this.function, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2) {
        HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function);
        if (this.needsInvocationSession) {
            Invocation invocation = new Invocation(context, this.postInvokeCount, this.referenceCount);
            try {
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    this.parameterMarshallers[i2].marshal(invocation, (InvocationBuffer)buffer, args2[i2]);
                }
                IRubyObject iRubyObject = this.functionInvoker.invoke(context, this.function, buffer);
                return iRubyObject;
            }
            finally {
                invocation.finish();
            }
        }
        for (int i3 = 0; i3 < args2.length; ++i3) {
            this.parameterMarshallers[i3].marshal(context, (InvocationBuffer)buffer, args2[i3]);
        }
        return this.functionInvoker.invoke(context, this.function, buffer);
    }
}

