"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDeprecationsPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  getEmptyPromptTitle: deprecationType => _i18n.i18n.translate('xpack.upgradeAssistant.noDeprecationsPrompt.description', {
    defaultMessage: 'Your {deprecationType} configuration is up to date',
    values: {
      deprecationType
    }
  }),
  getEmptyPromptDescription: navigateToOverviewPage => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.noDeprecationsPrompt.nextStepsDescription",
    defaultMessage: "Check the {overviewButton} for other Stack deprecations.",
    values: {
      overviewButton: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: navigateToOverviewPage
      }, _i18n.i18n.translate('xpack.upgradeAssistant.noDeprecationsPrompt.overviewLinkText', {
        defaultMessage: 'Overview page'
      }))
    }
  })
};
const NoDeprecationsPrompt = ({
  deprecationType,
  navigateToOverviewPage
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "check",
    "data-test-subj": "noDeprecationsPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18nTexts.getEmptyPromptTitle(deprecationType)),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "upgradeAssistantIssueSummary"
    }, i18nTexts.getEmptyPromptDescription(navigateToOverviewPage)))
  });
};
exports.NoDeprecationsPrompt = NoDeprecationsPrompt;