"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrimaryButtonLabel = exports.containerMessages = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrimaryButtonLabel = (status, resolutionType) => {
  switch (status) {
    case _types.DataStreamMigrationStatus.fetchFailed:
    case _types.DataStreamMigrationStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.reindexButton.tryAgainLabel",
        defaultMessage: "Try again"
      });
    case _types.DataStreamMigrationStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.reindexButton.reindexingLabel",
        defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} other {Migrating}}\u2026",
        values: {
          resolutionType
        }
      });
    case _types.DataStreamMigrationStatus.cancelled:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.reindexButton.restartLabel",
        defaultMessage: "{resolutionType, select, reindex {Restart reindexing} readonly {Restart setting to read-only} other {Restart migration}}",
        values: {
          resolutionType
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.reindexButton.runReindexLabel",
        defaultMessage: "{resolutionType, select, reindex {Start reindexing} readonly {Start setting to read-only} other {Start migration}}",
        values: {
          resolutionType
        }
      });
  }
};
exports.getPrimaryButtonLabel = getPrimaryButtonLabel;
const containerMessages = exports.containerMessages = {
  unknownMessage: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.unknownMessage', {
    defaultMessage: 'Unknown'
  }),
  errorLoadingDataStreamInfo: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.errorLoadingDataStreamInfo', {
    defaultMessage: 'Error loading data stream info'
  })
};