"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootComponent = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  GlobalFlyoutProvider
} = _shared_imports.GlobalFlyout;
const AppHandlingClusterUpgradeState = () => {
  const {
    services: {
      api,
      core
    }
  } = (0, _app_context.useAppContext)();
  const missingManageSpacesPrivilege = core.application.capabilities.spaces.manage !== true;
  const [clusterUpgradeState, setClusterUpgradeState] = (0, _react.useState)('isPreparingForUpgrade');
  (0, _react.useEffect)(() => {
    api.onClusterUpgradeStateChange(newClusterUpgradeState => {
      setClusterUpgradeState(newClusterUpgradeState);
    });
  }, [api]);
  if (missingManageSpacesPrivilege) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
      dataTestSubj: "missingKibanaPrivilegesMessage",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.app.deniedPrivilegeTitle",
        defaultMessage: "Kibana admin role required"
      }),
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.app.deniedPrivilegeDescription",
        defaultMessage: "To use Upgrade Assistant and resolve deprecation issues, you must have access to manage all Kibana spaces."
      })
    });
  }
  if (clusterUpgradeState === 'isUpgrading') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "logoElasticsearch",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradingTitle",
        defaultMessage: "Your cluster is upgrading"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradingDescription",
        defaultMessage: "One or more Elasticsearch nodes have a newer version of Elasticsearch than Kibana. Once all your nodes are upgraded, upgrade Kibana."
      })),
      "data-test-subj": "isUpgradingMessage"
    });
  }
  if (clusterUpgradeState === 'isUpgradeComplete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "logoElasticsearch",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradedTitle",
        defaultMessage: "Your cluster has been upgraded"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradedDescription",
        defaultMessage: "All Elasticsearch nodes have been upgraded. You may now upgrade Kibana."
      })),
      "data-test-subj": "isUpgradeCompleteMessage"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/overview",
    component: _components.Overview
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/es_deprecations",
    component: _components.EsDeprecations
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/kibana_deprecations",
    component: _components.KibanaDeprecations
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "/",
    to: "/overview"
  }));
};
const App = ({
  history
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();

  // Poll the API to detect when the cluster is either in the middle of
  // a rolling upgrade or has completed one. We need to create two separate
  // components: one to call this hook and one to handle state changes.
  // This is because the implementation of this hook calls the state-change
  // callbacks on every render, which will get the UI stuck in an infinite
  // render loop if the same component both called the hook and handled
  // the state changes it triggers.
  const {
    isLoading,
    isInitialRequest
  } = api.useLoadClusterUpgradeStatus();

  // Prevent flicker of the underlying UI while we wait for the status to fetch.
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(AppHandlingClusterUpgradeState, null));
};
exports.App = App;
const RootComponent = dependencies => {
  const {
    history,
    core: {
      application,
      http,
      executionContext,
      ...startServices
    }
  } = dependencies.services;
  executionContext.set({
    type: 'application',
    page: 'upgradeAssistant'
  });
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement("div", {
    className: _shared_imports.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.RedirectAppLinks, {
    coreStart: {
      application
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.AuthorizationProvider, {
    httpClient: http,
    privilegesEndpoint: `${_constants.API_BASE_PATH}/privileges`
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: dependencies
  }, /*#__PURE__*/_react.default.createElement(GlobalFlyoutProvider, null, /*#__PURE__*/_react.default.createElement(App, {
    history: history
  })))))));
};
exports.RootComponent = RootComponent;