"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedSearchPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _get_query_string_input = require("./query_string_input/get_query_string_input");
var _triggers = require("./triggers");
var _services = require("./services");
var _autocomplete_service = require("./autocomplete/autocomplete_service");
var _create_search_bar = require("./search_bar/create_search_bar");
var _index_pattern_select = require("./index_pattern_select");
var _constants = require("./actions/constants");
var _filters_builder = require("./filters_builder");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class UnifiedSearchPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "autocomplete", void 0);
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
    this.storage = new _public.Storage(window.localStorage);
    this.autocomplete = new _autocomplete_service.AutocompleteService(initializerContext);
  }
  setup(core, {
    uiActions,
    data,
    usageCollection
  }) {
    const {
      query
    } = data;
    uiActions.registerTrigger(_triggers.updateFilterReferencesTrigger);
    this.usageCollection = usageCollection;
    return {
      autocomplete: this.autocomplete.setup(core, {
        timefilter: query.timefilter,
        usageCollection
      })
    };
  }
  start(core, {
    data,
    dataViews,
    uiActions,
    screenshotMode
  }) {
    (0, _services.setCoreStart)(core);
    (0, _services.setIndexPatterns)(dataViews);
    const autocompleteStart = this.autocomplete.start();

    /*
     *
     *  unifiedsearch uses global data service to create stateful search bar.
     *  This function helps in creating a search bar with different instances of data service
     *  so that it can be easy to use multiple stateful searchbars in the single applications
     *
     * */
    const getCustomSearchBar = customDataService => (0, _create_search_bar.createSearchBar)({
      core,
      data: customDataService !== null && customDataService !== void 0 ? customDataService : data,
      storage: this.storage,
      usageCollection: this.usageCollection,
      isScreenshotMode: Boolean(screenshotMode === null || screenshotMode === void 0 ? void 0 : screenshotMode.isScreenshotMode()),
      unifiedSearch: {
        autocomplete: autocompleteStart
      }
    });
    const SearchBar = getCustomSearchBar();
    uiActions.addTriggerActionAsync(_public2.APPLY_FILTER_TRIGGER, _constants.ACTION_GLOBAL_APPLY_FILTER, async () => {
      const {
        createFilterAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/actions_module')));
      return createFilterAction(data.query.filterManager, data.query.timefilter.timefilter, core);
    });
    uiActions.addTriggerActionAsync(_triggers.UPDATE_FILTER_REFERENCES_TRIGGER, _constants.UPDATE_FILTER_REFERENCES_ACTION, async () => {
      const {
        createUpdateFilterReferencesAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions/actions_module')));
      return createUpdateFilterReferencesAction(data.query.filterManager);
    });
    return {
      ui: {
        IndexPatternSelect: (0, _index_pattern_select.createIndexPatternSelect)(dataViews),
        SearchBar,
        getCustomSearchBar,
        AggregateQuerySearchBar: SearchBar,
        FiltersBuilderLazy: _filters_builder.FiltersBuilderLazy,
        QueryStringInput: (0, _get_query_string_input.createQueryStringInput)({
          data,
          dataViews,
          docLinks: core.docLinks,
          http: core.http,
          notifications: core.notifications,
          storage: this.storage,
          uiSettings: core.uiSettings,
          unifiedSearch: {
            autocomplete: autocompleteStart
          }
        })
      },
      autocomplete: autocompleteStart
    };
  }
  stop() {
    this.autocomplete.clearProviders();
  }
}
exports.UnifiedSearchPublicPlugin = UnifiedSearchPublicPlugin;