"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionSummaryTitle = void 0;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _react = _interopRequireDefault(require("react"));
var _field_hover_popover_action = require("../../components/field_with_actions/field_hover_popover_action");
var _highlight_field = require("../../components/highlight_field.tsx");
var _transaction_name_link = require("../../components/transaction_name_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TransactionSummaryTitle = ({
  serviceName,
  transactionName,
  id,
  formattedId,
  formattedTransactionName,
  showActions = true
}) => {
  const FieldContent = ({
    children,
    field,
    title,
    value
  }) => {
    return showActions ? /*#__PURE__*/_react.default.createElement(_field_hover_popover_action.FieldHoverActionPopover, {
      title: title,
      value: value,
      field: field
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, transactionName ? /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: transactionName,
    value: transactionName,
    field: _discoverUtils.TRANSACTION_NAME_FIELD,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    value: transactionName,
    formattedValue: formattedTransactionName,
    as: "strong"
  }, ({
    content
  }) => /*#__PURE__*/_react.default.createElement(_transaction_name_link.TransactionNameLink, {
    serviceName: serviceName,
    transactionName: transactionName,
    renderContent: () => content
  }))) : /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: serviceName,
    value: serviceName,
    field: _discoverUtils.SERVICE_NAME_FIELD,
    showActions: showActions
  }, serviceName))), id && /*#__PURE__*/_react.default.createElement(FieldContent, {
    title: id,
    value: id,
    field: _discoverUtils.TRANSACTION_ID_FIELD,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
    value: id,
    formattedValue: formattedId,
    textSize: "xs"
  })));
};
exports.TransactionSummaryTitle = TransactionSummaryTitle;