"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitFullScreenButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExitFullScreenButton = ({
  ariaLabel,
  dataTestSubj,
  onExitFullScreen
}) => {
  const onKeyDown = (0, _react.useCallback)(event => {
    if (event.key === 'Escape') {
      event.preventDefault();
      onExitFullScreen();
    }
  }, [onExitFullScreen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": dataTestSubj,
    display: "base",
    iconSize: "m",
    iconType: "fullScreenExit",
    "aria-label": ariaLabel,
    onClick: onExitFullScreen
  }));
};
exports.ExitFullScreenButton = ExitFullScreenButton;