"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _section_loading = require("../../components/section_loading");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _connector_form_fields_global = require("./connector_form_fields_global");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorFormFieldsComponent = ({
  actionTypeModel,
  isEdit,
  registerPreSubmitValidator
}) => {
  var _actionTypeModel$acti;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const FieldsComponent = (_actionTypeModel$acti = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.actionConnectorFields) !== null && _actionTypeModel$acti !== void 0 ? _actionTypeModel$acti : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_form_fields_global.ConnectorFormFieldsGlobal, {
    canSave: canSave
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), FieldsComponent !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "connector-settings-label"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorForm.connectorSettingsLabel",
    defaultMessage: "Connector settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionConnectorForm.loadingConnectorSettingsDescription",
      defaultMessage: "Loading connector settings\u2026"
    }))
  }, /*#__PURE__*/_react.default.createElement(FieldsComponent, {
    readOnly: !canSave,
    isEdit: isEdit,
    registerPreSubmitValidator: registerPreSubmitValidator
  })))) : null);
};
const ConnectorFormFields = exports.ConnectorFormFields = /*#__PURE__*/(0, _react.memo)(ConnectorFormFieldsComponent);