"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkOperationToast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana = require("../../common/lib/kibana");
var _translations = require("../sections/rules_list/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionToToastMapping = {
  DELETE: {
    getSuccessfulNotificationText: _translations.getSuccessfulDeletionNotificationText,
    getFailedNotificationText: _translations.getFailedDeletionNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessDeletionNotificationText
  },
  ENABLE: {
    getSuccessfulNotificationText: _translations.getSuccessfulEnablingNotificationText,
    getFailedNotificationText: _translations.getFailedEnablingNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessEnablingNotificationText
  },
  DISABLE: {
    getSuccessfulNotificationText: _translations.getSuccessfulDisablingNotificationText,
    getFailedNotificationText: _translations.getFailedDisablingNotificationText,
    getPartialSuccessNotificationText: _translations.getPartialSuccessDisablingNotificationText
  }
};
const useBulkOperationToast = ({
  onSearchPopulate
}) => {
  const {
    i18n,
    theme,
    userProfile,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const onSearchPopulateInternal = (0, _react.useCallback)(errors => {
    if (!onSearchPopulate) {
      return;
    }
    const filter = errors.map(error => error.rule.name).join(',');
    onSearchPopulate(filter);
  }, [onSearchPopulate]);
  const renderToastErrorBody = (0, _react.useCallback)((errors, messageType) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "xs"
    }, onSearchPopulate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: messageType,
      size: "s",
      onClick: () => onSearchPopulateInternal(errors),
      "data-test-subj": "bulkDeleteResponseFilterErrors"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.filterByErrors",
      defaultMessage: "Filter by errored rules"
    }))));
  }, [onSearchPopulate, onSearchPopulateInternal]);
  const showToast = (0, _react.useCallback)(({
    action,
    errors,
    total
  }) => {
    const numberOfSuccess = total - errors.length;
    const numberOfErrors = errors.length;

    // All success
    if (!numberOfErrors) {
      toasts.addSuccess(actionToToastMapping[action].getSuccessfulNotificationText(numberOfSuccess, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE));
      return;
    }

    // All failure
    if (numberOfErrors === total) {
      toasts.addDanger({
        title: actionToToastMapping[action].getFailedNotificationText(numberOfErrors, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
        text: (0, _reactKibanaMount.toMountPoint)(renderToastErrorBody(errors, 'danger'), {
          i18n,
          theme,
          userProfile
        })
      });
      return;
    }

    // Some failure
    toasts.addWarning({
      title: actionToToastMapping[action].getPartialSuccessNotificationText(numberOfSuccess, numberOfErrors, _translations.SINGLE_RULE_TITLE, _translations.MULTIPLE_RULE_TITLE),
      text: (0, _reactKibanaMount.toMountPoint)(renderToastErrorBody(errors, 'warning'), {
        i18n,
        theme,
        userProfile
      })
    });
  }, [i18n, theme, userProfile, toasts, renderToastErrorBody]);
  return (0, _react.useMemo)(() => {
    return {
      showToast
    };
  }, [showToast]);
};
exports.useBulkOperationToast = useBulkOperationToast;