"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _transforms_stats = require("../../api_schemas/transforms_stats");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  getLicense
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {get} /internal/transform/transforms/_stats Get transforms stats
   * @apiName GetTransformsStats
   * @apiDescription Returns transforms stats
   */
  router.versioned.get({
    path: (0, _constants.addInternalBasePath)('transforms/_stats'),
    access: 'internal',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        query: _transforms_stats.getTransformStatsQuerySchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute(_route_handler.routeHandler)(ctx, request, response);
  });
}