"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeHandlerFactory = void 0;
var _error_utils = require("../../utils/error_utils");
var _delete_transforms = require("./delete_transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeHandlerFactory = ({
  getCoreStart,
  getDataViewsStart
}) => async (ctx, req, res) => {
  try {
    const {
      savedObjects,
      elasticsearch
    } = await getCoreStart();
    const savedObjectsClient = savedObjects.getScopedClient(req);
    const esClient = elasticsearch.client.asScoped(req).asCurrentUser;
    const dataViews = await getDataViewsStart();
    const dataViewsService = await dataViews.dataViewsServiceFactory(savedObjectsClient, esClient, req);
    const body = await (0, _delete_transforms.deleteTransforms)(req.body, ctx, res, dataViewsService);
    if (body && body.status) {
      if (body.status === 404) {
        return res.notFound();
      }
      if (body.status === 403) {
        return res.forbidden();
      }
    }
    return res.ok({
      body
    });
  } catch (e) {
    return res.customError((0, _error_utils.wrapError)((0, _error_utils.wrapEsError)(e)));
  }
};
exports.routeHandlerFactory = routeHandlerFactory;