"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartActionModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartActionModal = ({
  closeModal,
  items,
  startAndCloseModal
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const isBulkAction = items.length > 1;
  const bulkStartModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkStartModalTitle', {
    defaultMessage: 'Start {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: items && items.length
    }
  });
  const startModalTitle = _i18n.i18n.translate('xpack.transform.transformList.startModalTitle', {
    defaultMessage: 'Start {transformId}?',
    values: {
      transformId: items[0] && items[0].config.id
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "transformStartModal",
    "aria-labelledby": modalTitleId,
    title: isBulkAction === true ? bulkStartModalTitle : startModalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: startAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalStartButton', {
      defaultMessage: 'Start'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.transform.transformList.startModalBody', {
    defaultMessage: 'A transform increases search and indexing load in your cluster. If excessive load is experienced, stop the transform.'
  })));
};
exports.StartActionModal = StartActionModal;