"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteActionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../managed_transforms_callout/managed_transforms_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteActionModal = ({
  closeModal,
  deleteAndCloseModal,
  deleteDestIndex,
  deleteDataView,
  dataViewExists,
  items,
  shouldForceDelete,
  toggleDeleteIndex,
  toggleDeleteDataView,
  userCanDeleteIndex,
  userCanDeleteDataView
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const hasManagedTransforms = (0, _react.useMemo)(() => items.some(t => (0, _managed_transforms_utils.isManagedTransform)(t)), [items]);
  const isBulkAction = items.length > 1;
  const bulkDeleteModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkDeleteModalTitle', {
    defaultMessage: 'Delete {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: items.length
    }
  });
  const deleteModalTitle = _i18n.i18n.translate('xpack.transform.transformList.deleteModalTitle', {
    defaultMessage: 'Delete {transformId}?',
    values: {
      transformId: items[0] && items[0].config.id
    }
  });
  const bulkDeleteModalContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: items.length,
    action: _i18n.i18n.translate('xpack.transform.transformList.deleteManagedTransformDescription', {
      defaultMessage: 'deleting'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "transformBulkDeleteIndexSwitch",
    label: _i18n.i18n.translate('xpack.transform.actionDeleteTransform.bulkDeleteDestinationIndexTitle', {
      defaultMessage: 'Delete destination indices'
    }),
    checked: deleteDestIndex,
    onChange: toggleDeleteIndex
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "transformBulkDeleteDataViewSwitch",
    label: _i18n.i18n.translate('xpack.transform.actionDeleteTransform.bulkDeleteDestDataViewTitle', {
      defaultMessage: 'Delete destination data views'
    }),
    checked: deleteDataView,
    onChange: toggleDeleteDataView,
    disabled: userCanDeleteDataView === false
  }))));
  const deleteModalContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: 1,
    action: _i18n.i18n.translate('xpack.transform.transformList.deleteManagedTransformDescription', {
      defaultMessage: 'deleting'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, userCanDeleteIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "transformDeleteIndexSwitch",
    label: _i18n.i18n.translate('xpack.transform.actionDeleteTransform.deleteDestinationIndexTitle', {
      defaultMessage: 'Delete destination index {destinationIndex}',
      values: {
        destinationIndex: items[0] && items[0].config.dest.index
      }
    }),
    checked: deleteDestIndex,
    onChange: toggleDeleteIndex
  })), userCanDeleteIndex && dataViewExists && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "transformDeleteDataViewSwitch",
    label: _i18n.i18n.translate('xpack.transform.actionDeleteTransform.deleteDestDataViewTitle', {
      defaultMessage: 'Delete data view {destinationIndex}',
      values: {
        destinationIndex: items[0] && items[0].config.dest.index
      }
    }),
    checked: deleteDataView,
    onChange: toggleDeleteDataView,
    disabled: userCanDeleteDataView === false
  }))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "transformDeleteModal",
    title: isBulkAction === true ? bulkDeleteModalTitle : deleteModalTitle,
    onCancel: closeModal,
    onConfirm: deleteAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.deleteModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.deleteModalDeleteButton', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "danger",
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    }
  }, isBulkAction ? bulkDeleteModalContent : deleteModalContent);
};
exports.DeleteActionModal = DeleteActionModal;