"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateTransform = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../common/constants");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _components = require("../components");
var _use_refresh_transform_list = require("./use_refresh_transform_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateTransform = () => {
  const {
    http,
    ...startServices
  } = (0, _app_dependencies.useAppDependencies)();
  const refreshTransformList = (0, _use_refresh_transform_list.useRefreshTransformList)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  function errorToast(error, {
    transformId
  }) {
    toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.transform.stepCreateForm.createTransformErrorMessage', {
        defaultMessage: 'An error occurred creating the transform {transformId}:',
        values: {
          transformId
        }
      }),
      text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
        text: (0, _errors.getErrorMessage)(error)
      }), startServices)
    });
  }
  const mutation = (0, _reactQuery.useMutation)({
    mutationFn: ({
      transformId,
      transformConfig,
      createDataView = false,
      timeFieldName
    }) => {
      return http.put((0, _constants.addInternalBasePath)(`transforms/${transformId}`), {
        query: {
          createDataView,
          timeFieldName
        },
        body: JSON.stringify(transformConfig),
        version: '1'
      });
    },
    onError: errorToast,
    onSuccess: (resp, options) => {
      if (resp.errors.length > 0) {
        errorToast(resp.errors.length === 1 ? resp.errors[0] : resp.errors, options);
      }
      refreshTransformList();
    }
  });
  return mutation.mutate;
};
exports.useCreateTransform = useCreateTransform;