"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskManagerDependenciesPlugin = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TaskManagerDependenciesPlugin {
  setup(core, plugin) {
    plugin.encryptedSavedObjects.registerType({
      type: 'task',
      attributesToEncrypt: new Set(['apiKey']),
      attributesToIncludeInAAD: new Set(['id', 'taskType']),
      enforceRandomId: false
    });
    plugin.taskManager.registerCanEncryptedSavedObjects(plugin.encryptedSavedObjects.canEncrypt);
  }
  start(core, plugin) {
    plugin.taskManager.registerEncryptedSavedObjectsClient(plugin.encryptedSavedObjects.getClient({
      includedHiddenTypes: ['task']
    }));
  }
}
exports.TaskManagerDependenciesPlugin = TaskManagerDependenciesPlugin;