"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFakeKibanaRequest = getFakeKibanaRequest;
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFakeKibanaRequest(apiKey) {
  const requestHeaders = {};
  requestHeaders.authorization = `ApiKey ${Buffer.from(`${apiKey.id}:${apiKey.api_key}`).toString('base64')}`;
  const fakeRawRequest = {
    headers: requestHeaders,
    path: '/'
  };
  return (0, _coreHttpServerUtils.kibanaRequestFactory)(fakeRawRequest);
}