"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsValueToYamlFormatter = exports.tlsValueToStringFormatter = exports.tlsArrayToYamlFormatter = exports.stringifyString = exports.stringToJsonFormatter = exports.secondsToCronFormatter = exports.objectToJsonFormatter = exports.arrayToJsonFormatter = void 0;
var _formatting_utils = require("../formatting_utils");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayToJsonFormatter = (fields, key) => {
  var _ref;
  const value = (_ref = fields[key]) !== null && _ref !== void 0 ? _ref : [];
  return value.length ? JSON.stringify(value) : null;
};
exports.arrayToJsonFormatter = arrayToJsonFormatter;
const objectToJsonFormatter = (fields, fieldKey) => {
  var _ref2;
  const value = (_ref2 = fields[fieldKey]) !== null && _ref2 !== void 0 ? _ref2 : {};
  if (Object.keys(value).length === 0) return null;
  return JSON.stringify(value);
};

// only add tls settings if they are enabled by the user and isEnabled is true
exports.objectToJsonFormatter = objectToJsonFormatter;
const tlsValueToYamlFormatter = (fields, key) => {
  var _fields$ConfigKey$MET;
  if ((_fields$ConfigKey$MET = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET !== void 0 && _fields$ConfigKey$MET.is_tls_enabled) {
    var _ref3;
    const tlsValue = (_ref3 = fields[key]) !== null && _ref3 !== void 0 ? _ref3 : '';
    return tlsValue ? JSON.stringify(tlsValue) : null;
  } else {
    return null;
  }
};
exports.tlsValueToYamlFormatter = tlsValueToYamlFormatter;
const tlsValueToStringFormatter = (fields, key) => {
  var _fields$ConfigKey$MET2;
  if ((_fields$ConfigKey$MET2 = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET2 !== void 0 && _fields$ConfigKey$MET2.is_tls_enabled) {
    var _ref4;
    const tlsValue = (_ref4 = fields[key]) !== null && _ref4 !== void 0 ? _ref4 : '';
    return tlsValue || null;
  } else {
    return null;
  }
};
exports.tlsValueToStringFormatter = tlsValueToStringFormatter;
const tlsArrayToYamlFormatter = (fields, key) => {
  var _fields$ConfigKey$MET3;
  if ((_fields$ConfigKey$MET3 = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET3 !== void 0 && _fields$ConfigKey$MET3.is_tls_enabled) {
    var _ref5;
    const tlsValue = (_ref5 = fields[key]) !== null && _ref5 !== void 0 ? _ref5 : [];
    return tlsValue.length ? JSON.stringify(tlsValue) : null;
  } else {
    return null;
  }
};
exports.tlsArrayToYamlFormatter = tlsArrayToYamlFormatter;
const stringToJsonFormatter = (fields, key) => {
  var _ref6;
  if (key === _runtime_types.ConfigKey.SOURCE_INLINE) {
    const value = (0, _formatting_utils.inlineSourceFormatter)(fields, key);
    return value ? JSON.stringify(value) : null;
  }
  const value = (_ref6 = fields[key]) !== null && _ref6 !== void 0 ? _ref6 : '';
  return value ? JSON.stringify(value) : null;
};
exports.stringToJsonFormatter = stringToJsonFormatter;
const stringifyString = value => {
  if (!value) return value;
  try {
    return JSON.stringify(value);
  } catch (e) {
    return value;
  }
};
exports.stringifyString = stringifyString;
const secondsToCronFormatter = (fields, key) => {
  var _ref7;
  const value = (_ref7 = fields[key]) !== null && _ref7 !== void 0 ? _ref7 : '';
  return value ? `${value}s` : null;
};
exports.secondsToCronFormatter = secondsToCronFormatter;