"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGeoProperty = exports.modelVersion1 = exports.SyntheticsPrivateLocationsAttributesCodecLegacy = exports.PrivateLocationAttributesCodecLegacy = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateLocationAttributesCodecLegacy = exports.PrivateLocationAttributesCodecLegacy = t.intersection([t.interface({
  label: t.string,
  id: t.string,
  agentPolicyId: t.string,
  concurrentMonitors: t.number
}), t.partial({
  tags: t.array(t.string),
  /* Empty Lat lon was accidentally saved as an empty string instead of undefined or null
   * Need a migration to fix */
  geo: t.interface({
    lat: t.union([t.string, t.number]),
    lon: t.union([t.string, t.number])
  })
})]);
const SyntheticsPrivateLocationsAttributesCodecLegacy = exports.SyntheticsPrivateLocationsAttributesCodecLegacy = t.type({
  locations: t.array(PrivateLocationAttributesCodecLegacy)
});
const transformGeoProperty = privateLocationDoc => {
  const {
    locations
  } = privateLocationDoc.attributes;
  return {
    document: {
      ...privateLocationDoc,
      attributes: {
        locations: locations.map(location => {
          var _location$geo$lat, _location$geo, _location$geo$lon, _location$geo2;
          return {
            ...location,
            geo: {
              lat: Number((_location$geo$lat = (_location$geo = location.geo) === null || _location$geo === void 0 ? void 0 : _location$geo.lat) !== null && _location$geo$lat !== void 0 ? _location$geo$lat : 0),
              lon: Number((_location$geo$lon = (_location$geo2 = location.geo) === null || _location$geo2 === void 0 ? void 0 : _location$geo2.lon) !== null && _location$geo$lon !== void 0 ? _location$geo$lon : 0)
            },
            isServiceManaged: false
          };
        })
      }
    }
  };
};
exports.transformGeoProperty = transformGeoProperty;
const modelVersion1 = exports.modelVersion1 = {
  changes: [{
    type: 'unsafe_transform',
    transformFn: typeSafeGuard => typeSafeGuard(transformGeoProperty)
  }]
};