"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _register_embeddables = require("./apps/embeddables/register_embeddables");
var _kibana_service = require("./utils/kibana_service");
var _plugin = require("../common/constants/plugin");
var _ui = require("../common/constants/ui");
var _locators = require("./apps/locators");
var _alert_types = require("./apps/synthetics/lib/alert_types");
var _constants = require("./apps/embeddables/constants");
var _register_ui_actions = require("./apps/embeddables/ui_actions/register_ui_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SyntheticsPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "_packageInfo", void 0);
    this.initContext = initContext;
    this._packageInfo = initContext.env.packageInfo;
  }
  setup(coreSetup, plugins) {
    _locators.locators.forEach(locator => {
      plugins.share.url.locators.create(locator);
    });
    registerSyntheticsRoutesWithNavigation(coreSetup, plugins);
    coreSetup.getStartServices().then(([coreStart, clientPluginsStart]) => {
      _kibana_service.kibanaService.init({
        coreSetup,
        coreStart,
        startPlugins: clientPluginsStart,
        isDev: this.initContext.env.mode.dev,
        isServerless: this._isServerless
      });
    });
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];

    // Register the Synthetics UI plugin
    coreSetup.application.register({
      id: 'synthetics',
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.SYNTHETICS,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [{
        id: 'overview',
        title: this._isServerless ? _i18n.i18n.translate('xpack.synthetics.overviewPage.serverless.linkText', {
          defaultMessage: 'Overview'
        }) : _i18n.i18n.translate('xpack.synthetics.overviewPage.linkText', {
          defaultMessage: 'Monitors'
        }),
        path: '/'
      }, {
        id: 'certificates',
        title: _i18n.i18n.translate('xpack.synthetics.deepLink.certificatesPage.linkText', {
          defaultMessage: 'TLS Certificates'
        }),
        path: '/certificates'
      }],
      mount: async params => {
        _kibana_service.kibanaService.appMountParameters = params;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/synthetics/render_app')));
        await coreSetup.getStartServices();
        return renderApp(params);
      }
    });
    (0, _register_embeddables.registerSyntheticsEmbeddables)(coreSetup, plugins);
  }
  start(coreStart, pluginsStart) {
    const {
      triggersActionsUi
    } = pluginsStart;
    pluginsStart.dashboard.registerDashboardPanelPlacementSetting(_constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE, () => {
      return {
        width: 10,
        height: 8
      };
    });
    pluginsStart.dashboard.registerDashboardPanelPlacementSetting(_constants.SYNTHETICS_MONITORS_EMBEDDABLE, () => {
      return {
        width: 30,
        height: 12
      };
    });
    (0, _register_ui_actions.registerSyntheticsUiActions)(coreStart, pluginsStart);
    _alert_types.syntheticsAlertTypeInitializers.forEach(init => {
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        observabilityRuleTypeRegistry.register(alertInitializer);
      }
    });
  }
  stop() {}
  get _isServerless() {
    return this._packageInfo.buildFlavor === 'serverless';
  }
}
exports.SyntheticsPlugin = SyntheticsPlugin;
function registerSyntheticsRoutesWithNavigation(core, plugins) {
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.map)(([coreStart]) => {
    var _coreStart$applicatio;
    if ((_coreStart$applicatio = coreStart.application.capabilities.uptime) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.show) {
      return [{
        label: 'Synthetics',
        sortKey: 499,
        entries: [{
          label: _i18n.i18n.translate('xpack.synthetics.overview.SyntheticsHeading', {
            defaultMessage: 'Monitors'
          }),
          app: 'synthetics',
          path: _ui.OVERVIEW_ROUTE,
          matchFullPath: true,
          ignoreTrailingSlash: true
        }, {
          label: _i18n.i18n.translate('xpack.synthetics.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'synthetics',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  })));
}